# -*- coding : utf-8 -*-

# pynake.py

"""

Clássico Snake em Python.

Author : ik3k3h
Link : https://github.com/ik3k3h/Snake-in-PyGame

Tested py 3.7.0, Pygame 1.9.6, Windows 10.

"""

import pygame
from random import randrange

pygame.init()


#---------------------------------------------------------------------------

'COLORS (RGB)'
white = (255, 255, 255)
black = (0, 0, 0)
red = (255, 0, 0)

'WINDOW'
wid = hei = 300
screen = pygame.display.set_mode((wid, hei))
pygame.display.set_caption('Pynake')
icon = pygame.image.load('assets/images/icon/Pynake_Icon.png')
pygame.display.set_icon(icon)
scoreboard = 40

#---------------------------------------------------------------------------

def snake(snk_xy, size):

    for xy in snk_xy:
        pygame.draw.rect(screen, white, (xy[0], xy[1], size, size))

#---------------------------------------------------------------------------
        
def apple(apl_x, apl_y, size):
    pygame.draw.rect(screen, red, (apl_x, apl_y, size, size))

#---------------------------------------------------------------------------
    
def text(txt_msg, txt_clr, txt_x, txt_y, txt_size,):
    font = pygame.font.SysFont('arial', txt_size)
    txt = font.render(txt_msg, True, txt_clr)
    screen.blit(txt, (txt_x, txt_y))

#---------------------------------------------------------------------------
    
'MUSIC'
# pygame.mixer_music.load('assets/sounds/.mp3')
# pygame.mixer_music.play(-1)
# pygame.mixer_music.set_volume(0.3)

'SOUND EFFECTS'
snake_bite = pygame.mixer.Sound('assets/sounds/sound_effects/Snake_Bite.wav')
pygame.mixer.Sound.set_volume(snake_bite, 0.3)

#---------------------------------------------------------------------------

def game():
    main = True
    game_over = False
    clock = pygame.time.Clock()
    score = 0

    'SNAKE/APPLE'
    snk_x, snk_y = int(wid / 2), int(hei / 2)
    snk_xy = []
    snk_scale = 0
    size = 10
    spd_x = spd_y = 0
    # --- A maçã aparece em qualquer lugar da tela (menos dentro da scoreboard) e na posição correta --- #
    apl_x = randrange(0, wid - size, size)
    apl_y = randrange(0, hei - size - scoreboard, size)

    while main:
        clock.tick(5)
        screen.fill(black)
        pygame.draw.rect(screen, white, (0, hei - scoreboard, wid, scoreboard))

        text('Score: ' + str(score), black, 10, wid - scoreboard, 20)

        for event in pygame.event.get():
            if event.type == pygame.QUIT:
                main = False

            'CONTROLS'
            if event.type == pygame.KEYDOWN:
                if event.key == pygame.K_UP and spd_y != size:
                    spd_x = 0
                    spd_y = - size
                if event.key == pygame.K_DOWN and spd_y != -size:
                    spd_x = 0
                    spd_y = size
                if event.key == pygame.K_RIGHT and spd_x != -size:
                    spd_y = 0
                    spd_x = size
                if event.key == pygame.K_LEFT and spd_x != size:
                    spd_y = 0
                    spd_x = - size

        'SNAKE SPEED'
        snk_x += spd_x
        snk_y += spd_y

        'WALL COLISSION'
        if snk_x >= hei or snk_x < 0 or snk_y >= wid - scoreboard or snk_y < 0:
            game_over = True

        'APPLE COLISSION'
        if snk_x == apl_x and snk_y == apl_y:
            apl_x = randrange(0, wid - size, size)
            apl_y = randrange(0, hei - size - scoreboard, size)
            snake_bite.play()
            snk_scale += 1
            score += 1

        'SNAKE GROW UP'
        # --- Faz com que a cobra creça, mas só quando comer a maçã --- #
        if len(snk_xy) > snk_scale:
            del snk_xy[0]
        snk_head = [snk_x, snk_y]
        snk_xy.append(snk_head)

        'SNAKE COLISSION'
        if any(bloc == snk_head for bloc in snk_xy[: -1]):
            game_over = True

        snake(snk_xy, size)
        apple(apl_x, apl_y, size)

        pygame.display.update()

        'GAME OVER SCREEN'
        while game_over:
            screen.fill(black)
            pygame.draw.rect(screen, white, (30, 130, 100, 25))
            pygame.draw.rect(screen, white, (195, 130, 60, 25))

            text('Game Over', white, 90, 60, 30)
            text('Score: ' + str(score), white, 10, wid - scoreboard, 20)
            text('[S] Continuar', black, 30, 130, 20)
            text('[N] Sair', black, 195, 130, 20)

            for event in pygame.event.get():
                if event.type == pygame.QUIT:
                    game_over = False
                    main = False

                'CONTROLS/MOUSE'
                if event.type == pygame.KEYDOWN:
                    if event.key == pygame.K_s:
                        return game()
                    elif event.key == pygame.K_n:
                        game_over = False
                        main = False
                if event.type == pygame.MOUSEBUTTONDOWN:
                    mouse_x = pygame.mouse.get_pos()[0]
                    mouse_y = pygame.mouse.get_pos()[1]
                    if 30 < mouse_x < 130 < mouse_y < 155:
                        return game()
                    if 195 < mouse_x < 255 and 130 < mouse_y < 155:
                        game_over = False
                        main = False

            pygame.display.update()

#---------------------------------------------------------------------------
            
game()
pygame.quit()
