# sample_one.py

import sys
import os
import wx
import wx.lib.agw.flatmenu as FM

# class MyMenuBar
# class MyFrame
# class MyApp

#-------------------------------------------------------------------------------

class MyMenuBar(FM.FlatMenuBar):
    """
    A custom renderer class for FlatMenu.
    """
    def __init__(self, parent):
        FM.FlatMenuBar.__init__(self, parent,
                                id=wx.ID_ANY,
                                iconSize=32,
                                spacer=3,
                                options=FM.FM_OPT_IS_LCD)

        #------------
        
        self.parent = parent
        
        #------------

        # File Menu.
        self.file_menu = FM.FlatMenu()

        # Create the menu items.
        item = FM.FlatMenuItem(self.file_menu,
                               wx.CLOSE,
                               "&Open\tCtrl+O",
                               "Open file",
                               wx.ITEM_NORMAL,
                               None)
        item.SetTextColour("black")
        self.file_menu.AppendItem(item)
        self.file_menu.AppendSeparator()
        
        # Create the menu items.
        item = FM.FlatMenuItem(self.file_menu,
                               wx.ID_EXIT,
                               "&Quit\tCtrl+Q",
                               "Quit the program",
                               wx.ITEM_NORMAL,
                               None)
        # Demonstrate how to set custom font
        # and text colour to a FlatMenuItem.
        item.SetFont(wx.Font(-1, wx.FONTFAMILY_DEFAULT,
                             wx.FONTSTYLE_NORMAL,
                             wx.FONTWEIGHT_BOLD,
                             False, ""))
        item.SetTextColour("#e18619")

        self.file_menu.AppendItem(item)

        #------------
        
        # Help Menu.
        self.help_menu = FM.FlatMenu()

        # Create the menu items.
        item = FM.FlatMenuItem(self.help_menu,
                               wx.ID_ABOUT,
                               "&About\tCtrl+A",
                               "About",
                               wx.ITEM_NORMAL,
                               None)
        item.SetTextColour("black")
        self.help_menu.AppendItem(item)
        
        #------------
        
        # Add menu to the menu bar.
        self.Append(self.file_menu, "&File")
        self.Append(self.help_menu, "&Help")
        
#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id):        
        wx.Frame.__init__(self, parent, -1,
                          title="Main frame (no theme)")

        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.MakeMenuBar()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------
        
        self.CenterOnScreen()

    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """
        
        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "icon_wxWidgets.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)
        
    def MakeMenuBar(self):
        """
        ...
        """
        
        self.menuBar = MyMenuBar(self)


    def CreateCtrls(self):
        """
        ...
        """
        
        self.mainPnl = wx.Panel(self, -1)
        
        self.btn = wx.Button(self.mainPnl, -1, "Close Me")
        self.btn.SetPosition((15, 15))


    def BindEvents(self):
        """
        ...
        """
        
        # Bind the close event to an event handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btn)
        self.Bind(wx.EVT_MENU, self.OnCloseWindow, id=wx.ID_EXIT)

        
    def DoLayout(self):
        """
        ...
        """
        
        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        mbSizer = wx.BoxSizer(wx.HORIZONTAL)
        mbSizer.Add(self.menuBar, 1, wx.ALL, 0)

        mainSizer.Add(mbSizer, 0, wx.EXPAND, 0)
        mainSizer.Add(self.mainPnl, 1, wx.EXPAND, 0)

        # Finally, tell the panel to use the sizer for layout.
        self.SetSizer(mainSizer)
        self.Layout()


    def OnCloseMe(self, event):
        """
        ...
        """
        
        self.Close(True)


    def OnCloseWindow(self, event):
        """
        ...
        """
        
        self.Destroy()

#-------------------------------------------------------------------------------
      
class MyApp(wx.App):
    """
    ....
    """  
    def OnInit(self):

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------

        frame = MyFrame(None, -1)
        self.SetTopWindow(frame)
        frame.Show(True)
        
        return True

    #---------------------------------------------------------------------------

    def GetInstallDir(self):
        """
        Returns the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Returns the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir
    
#-------------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#-------------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
