# sample_two.py

import sys
import os
import wx
from   wx.adv import SplashScreen as SplashScreen

# class MyFrame
# class MySplash
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    ...
    """
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")

        #------------

        # Return application name.
        self.app_name = wx.GetApp().GetAppName()
        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen(wx.BOTH)

        #------------

        self.Show(True)

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle(self.app_name)
        self.SetSize((340, 250))

        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "icon_wxWidgets.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        ...
        """

        # Create a panel.
        self.panel = wx.Panel(self, -1)

        #------------

        # Add a button.
        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")


    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind events to an events handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)


    def DoLayout(self):
        """
        ...
        """

        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)
        # wx.BoxSizer(sizer, proportion, flag, border)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)


    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)


    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()

#---------------------------------------------------------------------------

class MySplash(SplashScreen):
    """
    ...
    """
    def __init__(self):

        self.SaveScreen()

        #------------

        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()

        #------------

        # Load a background bitmap.
        bmp = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                     "splashscreen.bmp"),
                        type=wx.BITMAP_TYPE_BMP)

        # Determine size of bitmap.
        imgSize = (bmp.GetWidth(), bmp.GetHeight())
        print("\n... Bitmap size : %sx%s px" % (imgSize))

        #------------

        super(MySplash, self).__init__(bitmap=bmp,
                                       splashStyle=wx.adv.SPLASH_TIMEOUT,
                                       milliseconds=4000,
                                       parent=None,
                                       id=-1,
                                       pos=wx.DefaultPosition,
                                       size=imgSize,
                                       style=wx.STAY_ON_TOP |
                                             wx.BORDER_NONE)

        #------------

        # Simplified init method.
        self.BindEvents()

        #------------

        print("\n... Display the splashScreen")

        #--------------

        wx.BeginBusyCursor()

    #-----------------------------------------------------------------------

    def BindEvents(self):
        """
        ...
        """

        # Bind events to an events handler.
        self.Bind(wx.EVT_CLOSE, self.OnClose)


    def SaveScreen(self):
        """
        ...
        """

        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()

        # Load a bitmap.
        bmp2 = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                      "shadow.png"),
                         type=wx.BITMAP_TYPE_PNG)

        # Bitmap size.
        w2, h2 = bmp2.GetSize()

        #------------

        # Create a screenshot.
        screen = wx.ScreenDC()

        # Screen size.
        w, h = screen.GetSize()
        print("\n... Screen size : %sx%s px" % (w, h))

        bmp = wx.Bitmap(w, h)

        mem = wx.MemoryDC(screen)
        mem.SelectObject(bmp)
        mem.Blit(0, 0, w, h, screen, 0, 0)
        # Draw a bitmap with an alpha
        # channel on the screenshot.
        # image, x, y, transparency.
        mem.DrawBitmap(bmp2, int((w-w2)/2), int((h-h2)/2), False)
        mem.SelectObject(wx.NullBitmap)

        #------------

        # Save a background bitmap for splashscreen.
        bmp.SaveFile(os.path.join(self.bitmaps_dir,
                                  "splashscreen.bmp"),
                     type=wx.BITMAP_TYPE_BMP)


    def OnClose(self, event):
        """
        Close the splash screen.
        This method will be called under 2 cases :
        1. time-limit is up, called automatically,
        2. you left-click on the splash-bitmap.
        """

        # Make sure the default handler runs
        # too so this window gets destroyed.
        # Tell the event system to continue
        # looking for an event handler, so the
        # default handler will get called.
        event.Skip()
        self.Hide()

        #------------

        self.ShowMainFrame()


    def ShowMainFrame(self):
        """
        ...
        """

        print("\n... Close the splash screen")
        print("\n... Create and display the main frame")

        #------------

        wx.CallAfter(wx.EndBusyCursor)

        #------------

        # Create an instance of the MyFrame class.
        frame = MyFrame()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        self.locale = wx.Locale(wx.LANGUAGE_ENGLISH)

        #------------

        self.SetAppName("Main frame")

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------

        splash = MySplash()
        splash.Show(True)

        return True

    #-----------------------------------------------------------------------

    def GetInstallDir(self):
        """
        Returns the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Returns the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir


    def GetBitmapsDir(self):
        """
        Returns the bitmaps directory for my application.
        """

        bitmaps_dir = os.path.join(self.installDir, "bitmaps")
        return bitmaps_dir

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()

