# sample_seven_a.py

import os
import sys
import platform
import time
import wx
import wx.lib.fancytext as fancytext
try:
    from wx.lib.mswalpha import draw_alpha
except ImportError:
    from mswalpha import draw_alpha

# class MyFrame
# class MySplash
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    ...
    """
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")

        #------------

        # Return application name.
        self.app_name = wx.GetApp().GetAppName()
        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen(wx.BOTH)

        #------------

        self.Show(True)

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle(self.app_name)
        self.SetSize((340, 200))

        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "icon_wxWidgets.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        ...
        """

        # Create a panel.
        self.panel = wx.Panel(self, -1)

        #------------

        # Add a buttons.
        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")


    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind events to an events handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)


    def DoLayout(self):
        """
        ...
        """

        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)
        # wx.BoxSizer(sizer, proportion, flag, border)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)


    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)


    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        wx.Exit()

#-------------------------------------------------------------------------------
        
class MySplash(wx.Frame):
    """
    Thanks to Robin Dunn.
    """
    style = (wx.FRAME_SHAPED | wx.BORDER_NONE |
             wx.FRAME_NO_TASKBAR | wx.STAY_ON_TOP)
    def __init__(self, parent, id=wx.ID_ANY, title=wx.EmptyString,
                 pos=wx.DefaultPosition, size=wx.DefaultSize,
                 style=style,
                 name='frame'):
        wx.Frame.__init__(self, parent, id, title, pos, size, style, name)
        
        #------------
        
        # Attributes.
        self.delta = wx.Point(0,0)
        
        #------------

        # Return application name.
        self.app_name = wx.GetApp().GetAppName()
        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()
        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------
        
        # Starts the Timer. Once Expired, splash is Destroyed.
        self.timer = wx.Timer(self)
        self.timer.Start(4000)
        self.Bind(wx.EVT_TIMER, self.TimeOut, self.timer)

        #--------------

        # Show main frame after 3000 ms.
        self.fc = wx.CallLater(3000, self.ShowMainFrame)

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()

        #--------------

        self.CenterOnScreen(wx.BOTH)

        #------------ 

        wx.BeginBusyCursor()
        
    #---------------------------------------------------------------------------
        
    def SetProperties(self):
        """
        ...
        """
 
        self.SetTitle(self.app_name)
        self.SetBackgroundStyle(wx.BG_STYLE_CUSTOM)

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "icon_wxWidgets.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        ...
        """
        
        # Load a background bitmap.
        self.bitmap = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                             "wxPython.png"),
                                type=wx.BITMAP_TYPE_PNG)
        # or
        # image = wx.Image('phone.png', wx.BITMAP_TYPE_PNG)
        # blurimage = image.Blur(1)
        # self.bitmap = blurimage.ConvertToBitmap()

        self.SetClientSize((self.bitmap.GetWidth(), self.bitmap.GetHeight()))

        #------------
        
        if wx.Platform == "__WXGTK__":
            # wxGTK requires that the window be created before you can
            # set its shape, so delay the call to SetWindowShape until
            # this event.
            self.Bind(wx.EVT_WINDOW_CREATE, self.SetWindowShape)
        else:
            # On wxMSW and wxMac the window has
            # already been created, so go for it.
            self.SetWindowShape()

        
    def BindEvents(self):
        """
        Bind some events to an events handle.
        """
     
        self.Bind(wx.EVT_ERASE_BACKGROUND, lambda x: None)
        # self.Bind(wx.EVT_MOTION, self.OnMouseMove)
        self.Bind(wx.EVT_LEFT_DOWN, self.OnLeftDown)
        self.Bind(wx.EVT_LEFT_UP, self.OnLeftUp)
        self.Bind(wx.EVT_RIGHT_UP, self.OnClose)
        self.Bind(wx.EVT_CHAR, self.OnCharEvents)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        
    def SetWindowShape(self, *event):
        """
        ...
        """
        
        # Use the bitmap's mask to determine the region.
        self.region = wx.Region(self.bitmap)
        self.hasShape = self.SetShape(self.region)

            
    def OnLeftDown(self, event):
        """
        ...
        """
        
        if self.HasCapture():
            self.ReleaseMouse()

        self.CaptureMouse()
        x, y = self.ClientToScreen(event.GetPosition())
        originx, originy = self.GetPosition()
        dx = x - originx
        dy = y - originy
        self.delta = (dx, dy)


    def OnLeftUp(self, event):
        """
        ...
        """
        
        if self.HasCapture():
            self.ReleaseMouse()


    def OnMouseMove(self, event):
        """
        ...
        """
        
        if event.Dragging() and event.LeftIsDown():
            x, y = self.ClientToScreen(event.GetPosition())
            fp = (x - self.delta[0], y - self.delta[1])
            self.SetPosition(fp)


    def Draw(self):
        """
        ...
        """

        # Return client size.
        width, height = self.GetClientSize()

        # Return main image size.
        bw, bh = self.bitmap.GetWidth(), self.bitmap.GetHeight()
        
        #------------

        dc = wx.MemoryDC()

        #------------
        
        fontSize = self.GetFont().GetPointSize()

        # wx.Font(pointSize, family, style, weight, underline, faceName)
        if wx.Platform == "__WXMSW__":
            self.normalBoldFont = wx.Font(fontSize-1,
                                          wx.DEFAULT, wx.NORMAL,
                                          wx.NORMAL, False, "")
            self.normalFont = wx.Font(fontSize,
                                      wx.DEFAULT, wx.NORMAL,
                                      wx.NORMAL, False, "")

        dc.SetFont(self.normalFont)
        dc.SetFont(self.normalBoldFont)

        #------------

        bmp = wx.Bitmap.FromRGBA(width, height, red=0, green=0, blue=0, alpha=0)
        dc.SelectObject(bmp)

        #------------
        
        gc = wx.GraphicsContext.Create(dc)
        gcdc = wx.GCDC(gc)

        # Draw a bitmap with an alpha channel
        # on top of the last group.
        # image, x, y, transparence
        gcdc.DrawBitmap(self.bitmap, -1, -1, useMask=False)

        # Draw text.
        gcdc.SetTextForeground(wx.Colour(255, 255, 255, 100))  # white
        gcdc.SetTextBackground(wx.TransparentColour)
        gcdc.SetFont(self.normalBoldFont)
        firstTxt = "wxPython is a Python extension module that\n"\
                   " encapsulates the wxWindows GUI classes."
        tw, th = gcdc.GetTextExtent(firstTxt)
        gcdc.DrawText(firstTxt, (int((bw-tw)/2), int(245)))

        gcdc.SetTextForeground(wx.Colour(250, 250, 250, 255))  # white
        gcdc.SetTextBackground(wx.TransparentColour)
        gcdc.SetFont(self.normalFont)
        secondTxt = " wxPython is brought to you by Robin Dunn and\n"\
                   "Total Control Software, Copyright (c) 1997-2020."
        tw, th = gcdc.GetTextExtent(secondTxt)
        gcdc.DrawText(secondTxt, (int((bw-tw)/2), int(280)))
        
        #------------

        gcdc.Destroy()
        del gcdc

        dc.Destroy()
        del dc

        #------------

        draw_alpha(self, bmp)


    def OnTimer(self, event):
        """
        ...
        """

        dc = wx.BufferedDC(wx.ClientDC(self))
        dc.Clear()
        
        self.Draw()
        
        
    def OnPaint(self, event):
        """
        ...
        """

        dc = wx.BufferedPaintDC(self)
        dc.Clear()
        
        self.Draw()


    def OnCharEvents(self, event):
        """
        Handles the wx.EVT_CHAR for Splash.
        This reproduces the behavior of wx.SplashScreen.
        """

        self.OnClose(event)


    def TimeOut(self, event):
        """
        ...
        """

        self.Close(True)
        

    def OnClose(self, event):
        """
        Handles the wx.EVT_CLOSE event for SplashScreen.
        """

        # Make sure the default handler runs
        # too so this window gets destroyed.
        # Tell the event system to continue
        # looking for an event handler, so the
        # default handler will get called.
        event.Skip()
        self.Hide()

        #------------

        # If the timer is still running then go
        # ahead and show the main frame now.
        if self.fc.IsRunning():
            # Stop the wx.CallLater timer.
            # Stop the splash screen timer
            # and close it.
            self.fc.Stop()
            self.ShowMainFrame()


    def ShowMainFrame(self):
        """
        ...
        """

        print("\n... Close the splash screen")
        print("\n... Create and display the main frame")

        #------------

        wx.CallAfter(wx.EndBusyCursor)

        #------------

        if self.fc.IsRunning():
            # Stop the splash screen
            # timer and close it.
            self.Raise()
            
        #------------

        # Create an instance of the MyFrame class.
        frame = MyFrame()


    def OnCloseWindow(self, event):
        """
        ...
        """
      
        self.timer.Stop()
        self.Destroy()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        self.locale = wx.Locale(wx.LANGUAGE_ENGLISH)

        #------------

        self.SetAppName("Main frame")

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------

        frame = MySplash(None)
        self.SetTopWindow(frame)
        frame.Show(True)
        
        return True

    #-----------------------------------------------------------------------

    def GetInstallDir(self):
        """
        Returns the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Returns the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir


    def GetBitmapsDir(self):
        """
        Returns the bitmaps directory for my application.
        """

        bitmaps_dir = os.path.join(self.installDir, "bitmaps")
        return bitmaps_dir

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
