# sample_one_b.py

import os
import sys
import platform
import wx

# class MyFrame
# class MyCaptionBox
# class MyPanel
# class MySplash
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    ...
    """
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")

        #------------

        # Return application name.
        self.app_name = wx.GetApp().GetAppName()
        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen(wx.BOTH)

        #------------

        self.Show(True)

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle(self.app_name)
        self.SetSize((340, 250))

        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "icon_wxWidgets.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        ...
        """

        # Create a panel.
        self.panel = wx.Panel(self, -1)

        #------------

        # Add a buttons.
        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")


    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind events to an events handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)


    def DoLayout(self):
        """
        ...
        """

        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)
        # wx.BoxSizer(sizer, proportion, flag, border)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)


    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)


    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        wx.Exit()

#---------------------------------------------------------------------------

class MyCaptionBox(wx.Panel):
    """
    ...
    """
    def __init__(self, parent, caption):
        super(MyCaptionBox, self).__init__(parent,
                                           style=wx.NO_BORDER |
                                                 wx.TAB_TRAVERSAL)

        #------------

        self.SetBackgroundColour("#344050")

        #------------

        # Attributes.
        self._caption = caption
        self._csizer = wx.BoxSizer(wx.VERTICAL)

        #------------

        # Simplified init method.
        self.BindEvents()
        self.DoLayout()

    #-----------------------------------------------------------------------

    def BindEvents(self):
        """
        ...
        """

        # Bind events to an events handler.
        self.Bind(wx.EVT_PAINT, self.OnPaint)


    def DoLayout(self):
        """
        ...
        """

        msizer = wx.BoxSizer(wx.HORIZONTAL)
        self._csizer.AddSpacer(15) # Extra space for caption.
        msizer.Add(self._csizer, 0, wx.EXPAND|wx.ALL, 0)
        self.SetSizer(msizer)


    def DoGetBestSize(self):
        """
        ...
        """

        size = super(MyCaptionBox, self).DoGetBestSize()
        # Compensate for wide caption labels.
        tw = self.GetTextExtent(self._caption)[0]
        size.SetWidth(max(size.width, tw))
        return size


    def AddItem(self, item):
        """
        Add a window or sizer item to the caption box.
        """

        self._csizer.Add(item, 0, wx.ALL, 5)


    def OnPaint(self, event):
        """
        Draws the Caption and border around the controls.
        """

        dc = wx.BufferedPaintDC(self)
        dc.SetBackground(wx.Brush(wx.BLACK))
        dc.Clear()
        gcdc = wx.GCDC(dc)

        # Get the working rectangle we can draw in.
        rect = self.GetClientRect()

        # Get the sytem color to draw the caption.
        ss = wx.SystemSettings
        color = ss.GetColour(wx.SYS_COLOUR_3DDKSHADOW)
        gcdc.SetTextForeground(wx.WHITE)

        # Draw the border.
        rect.Inflate(-0, -0)
        gcdc.SetPen(wx.Pen(color))
        gcdc.SetBrush(wx.Brush(wx.Colour(70, 70, 70, 255)))
        gcdc.DrawRoundedRectangle(rect, 5)

        # Font size and style.
        font = self.GetFont().GetPointSize()
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font.SetWeight(wx.BOLD)

        # Add the Caption.
        rect = wx.Rect(rect.x, rect.y, rect.width, 20)
        rect.Inflate(-5, 0)
        gcdc.SetFont(font)
        gcdc.DrawLabel(self._caption, rect, wx.ALIGN_CENTER)

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    """
    ...
    """
    def __init__(self, parent):
        wx.Panel.__init__(self, parent)

        #------------

        self.SetBackgroundStyle(wx.BG_STYLE_CUSTOM)

        #------------

        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()

        # Load a background bitmap.
        self.bmp = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                          "rocket.png"),
                             type=wx.BITMAP_TYPE_PNG)

        #------------

        # Attributes.
        self.box1 = MyCaptionBox(self, "Loading...")

        #------------

        # Put a gauge in the box.
        self.count = 0

        self.gauge = wx.Gauge(self.box1,
                              id=-1,
                              range=20,
                              size=(155, 15))
        self.box1.AddItem(self.gauge)

        #------------

        # Create a timer for my gauge.
        self.timer = wx.Timer(self)

        # Gauge speed. Simulate long startup time.
        self.timer.Start(90)

        self.Bind(wx.EVT_TIMER, self.TimerHandler, self.timer)

        #------------
        
        # Simplified init method.
        self.BindEvents()
        self.DoLayout()
        
        #------------
        
        self.SetClientSize((514, 386))
        
    #-----------------------------------------------------------------------

    def BindEvents(self):
        """
        ...
        """

        # Bind event to an events handler.
        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_WINDOW_DESTROY, self.OnDestroy)
        self.box1.Bind(wx.EVT_MOUSE_EVENTS, self.OnMouseEvents)
        self.gauge.Bind(wx.EVT_MOUSE_EVENTS, self.OnMouseEvents)
        

    def DoLayout(self):
        """
        ...
        """

        hsizer = wx.BoxSizer(wx.HORIZONTAL)
        vsizer = wx.BoxSizer(wx.VERTICAL)

        #------------

        # Add the box to the panel.
        hsizer.AddStretchSpacer()
        hsizer.Add(self.box1, 0, wx.EXPAND)
        hsizer.AddSpacer(0)
        vsizer.AddStretchSpacer()
        vsizer.Add(hsizer, 0, wx.EXPAND|wx.ALL, 15)

        self.SetSizer(vsizer)


    def OnPaint(self, event):
        """
        ...
        """

        dc = wx.BufferedPaintDC(self)
        dc.Clear()
        gcdc = wx.GCDC(dc)
        gcdc.Clear()

        # Draw a bitmap with an alpha channel
        # on top of the last group.
        gcdc.DrawBitmap(self.bmp, 0, 0, False)


    def TimerHandler(self, event):
        """
        ...
        """

        self.count = self.count + 1

        if self.count >= 90:
            self.count = 0

        self.gauge.SetValue(self.count)
        # or
        # self.gauge.Pulse()


    def OnMouseEvents(self, event):
        """
        Handles the wx.EVT_MOUSE_EVENTS for AdvancedSplash.
        This reproduces the behavior of wx.SplashScreen.
        """

        if event.LeftDown() or event.RightDown():
            splash = wx.GetApp().GetTopWindow()
            splash.OnClose(event)

        event.Skip()


    def OnDestroy(self, event):
        """
        ...
        """

        event.Skip()
        
#---------------------------------------------------------------------------

class MySplash(wx.Frame):
    """
    ...
    """
    def __init__(self):

        #--------------
        
        screen = wx.ScreenDC()
        
        # Screen size.
        ws, hs = screen.GetSize()

        #--------------
        
        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()

        # Load a background bitmap.
        self.bmp = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                          "rocket.png"),
                             type=wx.BITMAP_TYPE_PNG)

        mask = wx.Mask(self.bmp, wx.RED)
        self.bmp.SetMask(mask)
        
        # Determine size of bitmap.
        wi, hi = self.bmp.GetWidth(), self.bmp.GetHeight()
        print("\n... Bitmap size : %sx%s px" % (wi, hi))

        x = int((ws-wi)/2)
        y = int((hs-hi)/2)
        
        #--------------
        
        super(MySplash, self).__init__(parent=None,
                                       id=-1,
                                       title="SplashScreen",
                                       pos=(x, y),
                                       size=(wi, hi),
                                       style=wx.FRAME_SHAPED |
                                             wx.BORDER_NONE |
                                             wx.FRAME_NO_TASKBAR |
                                             wx.STAY_ON_TOP)

        #--------------
        
        self.SetBackgroundColour("#344050")

        #--------------

        # Attributes.
        self.SetTransparent(0)
        self.opacity_in = 0
        self.deltaN = -30
        self.hasShape = False

        #--------------
        
        if wx.Platform != "__WXMAC__":
            # wxMac clips the tooltip to the window shape, YUCK!!!
            self.SetToolTip("Right-click to close the window\n"
                            "Double-click the image to set/unset the window shape")

        if wx.Platform == "__WXGTK__":
            # wxGTK requires that the window be created before you can
            # set its shape, so delay the call to SetWindowShape until
            # this event.
            self.Bind(wx.EVT_WINDOW_CREATE, self.SetWindowShape)
        else:
            # On wxMSW and wxMac the window has already 
            # been created, so go for it.
            self.SetWindowShape()

        #--------------
        
        # Starts the Timer. Once Expired, splash is Destroyed.
        self.timer = wx.Timer(self)

        # Simulate long startup time.
        self.timer.Start(4000)

        self.Bind(wx.EVT_TIMER, self.TimeOut, self.timer)

        #--------------

        # Show main frame after 3000 ms.
        self.fc = wx.CallLater(3000, self.ShowMainFrame)

        #--------------

        self.CenterOnScreen(wx.BOTH)
        self.Show(True)

        #--------------

        # Simplified init method.
        self.OnTimerIn(self)
        self.CreateCtrls()
        self.DoLayout()

        #--------------

        print("\n... Display the splashScreen")

        #--------------

        self.SetClientSize((wi, hi))
        wx.BeginBusyCursor()

    #-----------------------------------------------------------------------

    def OnTimerIn(self, evt):
        """
        Thanks to Pascal Faut.
        """

        self.timer1 = wx.Timer(self, -1)
        self.timer1.Start(1)
        self.Bind(wx.EVT_TIMER, self.AlphaCycle1, self.timer1)

        print("Fade-in was launched.")


    def AlphaCycle1(self, *args):
        """
        Thanks to Pascal Faut.
        """

        self.opacity_in += self.deltaN
        if self.opacity_in <= 0:
            self.deltaN = -self.deltaN
            self.opacity_in = 0

        if self.opacity_in >= 255:
            self.deltaN = -self.deltaN
            self.opacity_in = 255

            self.timer1.Stop()

        self.SetTransparent(self.opacity_in)

        print("Fade in = {}/255".format(self.opacity_in))

        
    def CreateCtrls(self):
        """
        ...
        """

        self.panel = MyPanel(self)


    def BindEvents(self):
        """
        Bind all the events related to my app.
        """

        # Bind some events to an events handler.
        self.Bind(wx.EVT_CHAR, self.OnCharEvents)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        self.panel.Bind(wx.EVT_LEFT_DOWN, self.OnClose)


    def DoLayout(self):
        """
        ...
        """

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.panel, 1, wx.EXPAND)
        self.SetSizer(sizer)


    def SetWindowShape(self, *evt):
        """
        ...
        """
        
        # Use the bitmap's mask to determine the region.
        r = wx.Region(self.bmp)
        self.hasShape = self.SetShape(r)
        

    def OnCharEvents(self, event):
        """
        Handles the wx.EVT_CHAR for Splash.
        This reproduces the behavior of wx.SplashScreen.
        """

        self.OnClose(event)


    def TimeOut(self, event):
        """
        ...
        """

        self.Close(True)


    def OnCloseWindow(self, event):
        """
        ...
        """

        print("\n... Close timer")

        #--------------

        if hasattr(self, "timer"):
            self.Show(False)
            self.timer.Stop()
            del self.timer


    def OnClose(self, event):
        """
        Handles the wx.EVT_CLOSE event for SplashScreen.
        """

        # Make sure the default handler runs
        # too so this window gets destroyed.
        # Tell the event system to continue
        # looking for an event handler, so the
        # default handler will get called.
        event.Skip()
        self.Hide()

        #------------

        # If the timer is still running then go
        # ahead and show the main frame now.
        if self.fc.IsRunning():
            # Stop the wx.CallLater timer.
            # Stop the splash screen timer
            # and close it.
            self.fc.Stop()
            self.ShowMainFrame()


    def ShowMainFrame(self):
        """
        ...
        """

        print("\n... Close the splash screen")
        print("\n... Create and display the main frame")

        #------------

        wx.CallAfter(wx.EndBusyCursor)

        #------------

        if self.fc.IsRunning():
            # Stop the splash screen
            # timer and close it.
            self.Raise()

        #------------
            
        # Create an instance of the MyFrame class.
        frame = MyFrame()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        self.locale = wx.Locale(wx.LANGUAGE_ENGLISH)

        #------------

        self.SetAppName("Main frame")

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------

        splash = MySplash()
        splash.BindEvents()
        splash.CenterOnScreen(wx.BOTH)

        return True

    #-----------------------------------------------------------------------

    def GetInstallDir(self):
        """
        Returns the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Returns the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir


    def GetBitmapsDir(self):
        """
        Returns the bitmaps directory for my application.
        """

        bitmaps_dir = os.path.join(self.installDir, "bitmaps")
        return bitmaps_dir

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
