# sample_five.py

import os
import sys
import platform
import wx

# class MyFrame
# class MyPanel
# class MySplash
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    ...
    """
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")

        #------------

        # Return application name.
        self.app_name = wx.GetApp().GetAppName()
        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen(wx.BOTH)

        #------------

        self.Show(True)

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle(self.app_name)
        self.SetSize((340, 250))

        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "icon_wxWidgets.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def CreateCtrls(self):
        """
        ...
        """

        # Create a panel.
        self.panel = wx.Panel(self, -1)

        #------------

        # Add a buttons.
        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")


    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind events to an events handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)


    def DoLayout(self):
        """
        ...
        """

        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)
        # wx.BoxSizer(sizer, proportion, flag, border)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)
        

    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)


    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        
#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    """
    ...
    """
    def __init__(self, parent):
        wx.Panel.__init__(self, parent)

        #------------

        self.SetBackgroundStyle(wx.BG_STYLE_CUSTOM)

        #------------

        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()

        # Load a background bitmap.
        self.bmp = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                          "mask.png"),
                             type=wx.BITMAP_TYPE_PNG)

        #------------

        # Simplified init method.
        self.BindEvents()

    #-----------------------------------------------------------------------

    def BindEvents(self):
        """
        ...
        """

        # Bind event to an events handler.
        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_WINDOW_DESTROY, self.OnDestroy)


    def OnPaint(self, event):
        """
        ...
        """

        dc = wx.BufferedPaintDC(self)
        dc.Clear()
        gcdc = wx.GCDC(dc)
        gcdc.Clear()

        # Draw a bitmap with an alpha channel
        # on top of the last group.
        gcdc.DrawBitmap(self.bmp, 0, 0, False)


    def OnMouseEvents(self, event):
        """
        Handles the wx.EVT_MOUSE_EVENTS for AdvancedSplash.
        This reproduces the behavior of wx.SplashScreen.
        """

        if event.LeftDown() or event.RightDown():
            splash = wx.GetApp().GetTopWindow()
            splash.OnClose(event)

        event.Skip()


    def OnDestroy(self, event):
        """
        ...
        """

        event.Skip()
        
#---------------------------------------------------------------------------

class MySplash(wx.Frame):
    """
    ...
    """
    def __init__(self,
                 parent=None,
                 id=-1,
                 title="SplashScreen",
                 pos=wx.DefaultPosition,
                 size=wx.DefaultSize,
                 style=wx.FRAME_SHAPED |
                       wx.BORDER_NONE |
                       wx.FRAME_NO_TASKBAR |
                       wx.STAY_ON_TOP):

        #--------------

        # Return bitmaps folder.
        self.bitmaps_dir = wx.GetApp().GetBitmapsDir()

        # Load a background bitmap.
        self.bmp = wx.Bitmap(os.path.join(self.bitmaps_dir,
                                          "mask.png"),
                             type=wx.BITMAP_TYPE_PNG)
        
        mask = wx.Mask(self.bmp, wx.RED)
        self.bmp.SetMask(mask)
        
        # Determine size of bitmap.
        w, h = self.bmp.GetWidth(), self.bmp.GetHeight()
        print("\n... Bitmap size : %sx%s px" % (w, h))

        #--------------
        
        super(MySplash, self).__init__(parent,
                                       id,
                                       title,
                                       pos,
                                       size,
                                       style)

        #--------------

        self.SetBackgroundStyle(wx.BG_STYLE_CUSTOM)

        #--------------
        
        # Attributes.
        self.hasShape = False

        #--------------
        
        if wx.Platform != "__WXMAC__":
            # wxMac clips the tooltip to the window shape, YUCK!!!
            self.SetToolTip("Right-click to close the window\n"
                            "Double-click the image to set/unset the window shape")

        if wx.Platform == "__WXGTK__":
            # wxGTK requires that the window be created before you can
            # set its shape, so delay the call to SetWindowShape until
            # this event.
            self.Bind(wx.EVT_WINDOW_CREATE, self.SetWindowShape)
        else:
            # On wxMSW and wxMac the window has already 
            # been created, so go for it.
            self.SetWindowShape()

        #--------------
        
        # Starts the Timer. Once Expired, splash is Destroyed.
        self.timer = wx.Timer(self)

        # Simulate long startup time.
        self.timer.Start(4000)

        self.Bind(wx.EVT_TIMER, self.TimeOut, self.timer)

        #--------------

        # Show main frame after 3000 ms.
        self.fc = wx.CallLater(3000, self.ShowMainFrame)

        #--------------

        self.CenterOnScreen(wx.BOTH)
        self.Show(True)

        #--------------

        # Simplified init method.
        self.CreateCtrls()
        self.DoLayout()

        #--------------

        print("\n... Display the splashScreen")

        #--------------

        self.SetClientSize((w, h))
        wx.BeginBusyCursor()

    #-----------------------------------------------------------------------

    def CreateCtrls(self):
        """
        ...
        """

        self.panel = MyPanel(self)


    def BindEvents(self):
        """
        Bind all the events related to my app.
        """

        # Bind some events to an events handler.
        self.Bind(wx.EVT_CHAR, self.OnCharEvents)
        self.Bind(wx.EVT_CLOSE, self.OnClose)
        self.panel.Bind(wx.EVT_LEFT_DOWN, self.OnClose)
        self.Bind(wx.EVT_CLOSE, self.CloseWindow)
        

    def DoLayout(self):
        """
        ...
        """

        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.panel, 1, wx.EXPAND)
        self.SetSizer(sizer)


    def SetWindowShape(self, *evt):
        """
        ...
        """
        
        # Use the bitmap's mask to determine the region.
        r = wx.Region(self.bmp)
        self.hasShape = self.SetShape(r)
        

    def OnCharEvents(self, event):
        """
        Handles the wx.EVT_CHAR for Splash.
        This reproduces the behavior of wx.SplashScreen.
        """

        self.OnClose(event)


    def TimeOut(self, event):
        """
        ...
        """

        self.Close(True)


    def OnClose(self, event):
        """
        Handles the wx.EVT_CLOSE event for SplashScreen.
        """

        # Make sure the default handler runs
        # too so this window gets destroyed.
        # Tell the event system to continue
        # looking for an event handler, so the
        # default handler will get called.
        event.Skip()
        self.Hide()

        #------------

        # If the timer is still running then go
        # ahead and show the main frame now.
        if self.fc.IsRunning():
            # Stop the wx.CallLater timer.
            # Stop the splash screen timer
            # and close it.
            self.fc.Stop()
            self.ShowMainFrame()


    def ShowMainFrame(self):
        """
        ...
        """

        print("\n... Close the splash screen")
        print("\n... Create and display the main frame")

        #------------

        wx.CallAfter(wx.EndBusyCursor)

        #------------

        if self.fc.IsRunning():
            # Stop the splash screen
            # timer and close it.
            self.Raise()

        #------------
            
        # Create an instance of the MyFrame class.
        frame = MyFrame()


    def CloseWindow(self, event):
        """
        ...
        """
      
        self.timer.Stop()
        self.Destroy()
        
#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        self.locale = wx.Locale(wx.LANGUAGE_ENGLISH)

        #------------

        self.SetAppName("Main frame")

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------

        splash = MySplash(None, -1)
        splash.BindEvents()
        splash.CenterOnScreen(wx.BOTH)

        return True

    #-----------------------------------------------------------------------

    def GetInstallDir(self):
        """
        Returns the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Returns the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir


    def GetBitmapsDir(self):
        """
        Returns the bitmaps directory for my application.
        """

        bitmaps_dir = os.path.join(self.installDir, "bitmaps")
        return bitmaps_dir

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
