# sample_two.py

"""

https://ideal-user-interface.hatenablog.com/entry/20110929/1317254204

"""

import os
import sys
import wx

# class MyLoginDialog
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyLoginDialog(wx.Dialog):
    def __init__(self, *args, **kwargs):
        super(MyLoginDialog, self).__init__(*args, **kwargs)
        
        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------
        
        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.DoLayout()
        
    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)
        self.SetTitle("Login")
        
        
    def CreateCtrls(self):
        """
        ...
        """

        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font.SetWeight(wx.BOLD)

        #------------
        
        self.pnl = wx.Panel(self)

        #------------
        
        self.username = wx.TextCtrl(self.pnl)
        self.passwd = wx.TextCtrl(self.pnl)

        self.userTxt = wx.StaticText(self.pnl, label="Username :")
        self.userTxt.SetFont(font)        
        self.pwdTxt = wx.StaticText(self.pnl, label="Password :")
        self.pwdTxt.SetFont(font)
        
        #------------
        
        self.btnOk = wx.Button(self.pnl, wx.ID_OK)
        self.btnOk.SetDefault()

        self.btnCancel = wx.Button(self.pnl, wx.ID_CANCEL)
        
        
    def DoLayout(self):
        """
        ...
        """        
        
        sizer = wx.FlexGridSizer(2, 2, 8, 8)
        sizer.Add(self.userTxt,
                  0, wx.ALIGN_CENTER_VERTICAL)
        sizer.Add(self.username, 0, wx.EXPAND)
        sizer.Add(self.pwdTxt,
                  0, wx.ALIGN_CENTER_VERTICAL)
        sizer.Add(self.passwd, 0, wx.EXPAND)

        #------------
        
        msizer = wx.BoxSizer(wx.VERTICAL)
        msizer.Add(sizer, 1, wx.EXPAND|wx.ALL, 20)

        btnszr = wx.StdDialogButtonSizer()
        btnszr.AddButton(self.btnOk)
        btnszr.AddButton(self.btnCancel)
        
        msizer.Add(btnszr, 0, wx.ALIGN_CENTER|wx.ALL, 12)
        btnszr.Realize()

        self.pnl.SetSizer(msizer)

        #------------
        
        vsizer = wx.BoxSizer(wx.VERTICAL)
        vsizer.Add(self.pnl, 1, wx.EXPAND)

        #------------
        
        self.SetSizer(vsizer)
        self.SetInitialSize()

        
    def GetUser(self):
        """
        ...
        """
        
        return self.username.GetValue()


    def GetPasswd(self):
        """
        ...
        """
        
        return self.passwd.GetValue()
        
#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)

        #------------

        # Return icons folder.
        self.icons_dir = wx.GetApp().GetIconsDir()

        #------------
        
        # Simplified init method.
        self.SetProperties()

        #------------

        self.btnClose = wx.Button(self, wx.ID_EXIT,
                                  label="&Quit")

        #------------
        
        sizerMain = wx.BoxSizer(wx.VERTICAL)
        sizerMain.Add(self.btnClose, 0, wx.EXPAND)

        #------------
        
        self.btnClose.Bind(wx.EVT_BUTTON, self.OnCloseWindow)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetMinSize((420, 200))
        self.SetBackgroundColour(wx.Colour("#eceade"))
        
        #------------

        frameIcon = wx.Icon(os.path.join(self.icons_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frameIcon)


    def OnCloseBtn(self, event):
        """
        ...
        """

        self.Close(True)

          
    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
          
#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------
        
        login = MyLoginDialog(None)
        loggedIn = False
        while not loggedIn:
            dlg = login.ShowModal()
            if dlg == wx.ID_OK:
                uname = login.GetUser()
                passwd = login.GetPasswd()
                if (uname, passwd) == ("hoge", "hoge"):
                    loggedIn = True
                else:
                    print("Username or password is incorrect !")
            else:
                self.Destroy()
                
        self.frm = MyFrame(None, -1, 'Sample two')                
        self.frm.Show(True)
        
        return True
        
    #---------------------------------------------------------------------------

    def GetInstallDir(self):
        """
        Returns the installation directory for my application.
        """

        return self.installDir


    def GetIconsDir(self):
        """
        Returns the icons directory for my application.
        """

        icons_dir = os.path.join(self.installDir, "icons")
        return icons_dir
        
#-------------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#-------------------------------------------------------------------------------

if __name__ == "__main__" :
    main()


