# sample_four.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    """
    Create a panel with a canvas to draw on.
    """
    
    def __init__(self, parent, size):
        wx.Panel.__init__(self, parent, -1, size=size)

        self.SetBackgroundStyle(wx.BG_STYLE_CUSTOM)

        #------------
        
        w, h = self.GetClientSize()

        #------------
        
        # Initial y position of image        
        self.y = -h

        #------------
        
        self.timer = wx.Timer(self)
        # Start(int milliseconds, oneShot=False).
        # Lower timer interval gives faster speed.
        self.timer.Start(10)
        self.Bind(wx.EVT_TIMER, self.OnTimer, self.timer)

        #------------

        # Simplified init method.
        self.BindEvents()
        
    #-----------------------------------------------------------------------

    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        self.Bind(wx.EVT_SIZE, self.OnResize)
        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_ERASE_BACKGROUND, self.OnErase)
        # self.Bind(wx.EVT_MOUSE_EVENTS, self.OnMouseEvents)

        
    def OnMouseEvents(self, event):
        """
        ...
        """
        
        if event.LeftDown() :
            self.timer.Stop()
        else:
            self.timer.Start()
        event.Skip()


    def OnErase(self, evt):
        """
        Noop because of double buffering.
        """
        
        pass

    
    def OnResize(self, event):
        """
        Refresh widget after resizing.
        """

        self.Refresh()
        event.Skip()


    def OnPaint(self, event=None):
        """
        Create the paint canvas.
        """

        dc = wx.BufferedPaintDC(self)
        brush = wx.Brush("gray")
        dc.SetBackground(brush)
        dc.Clear()
        
        #------------
        
        font = dc.GetFont()
        font.SetWeight(wx.BOLD)
        font.SetPointSize(12)
        # font.SetFaceName("Tahoma") 
        dc.SetFont(font)

        #------------
        
        width, height = self.GetClientSize()

        #------------

        txt = "Loop for the text !!!"

        w, h = dc.GetTextExtent(txt)
        
        #------------

        dc.SetTextForeground("white")
        dc.DrawText(txt, int(width/2-(w/2)), int(self.y))
        

    def OnTimer(self, event):
        """

        """

        w, h = self.GetClientSize()

        #------------
        
        # Increment x to start moving.
        self.y += -0.5
        # Optional continuous movement
        # experiment with wrap around values.
        if self.y > h or self.y < -100:
            self.y = h
            
        self.Refresh()

#---------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    """
    ...
    """
    
    def __init__(self):
        wx.Frame.__init__(self, None,
                          title="Vertical news-ticker (text)",
                          size=(400, 120))

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.DoLayout()

        #------------

        self.CenterOnScreen()

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetIcon(wx.Icon('icons/wxwin.ico'))
        self.SetMinSize((100, 80))


    def CreateCtrls(self):
        """
        ...
        """

        size = self.GetClientSize()

        self.pnl = MyPanel(self, size=size)


    def DoLayout(self):
        """
        ...
        """

        mainSizer = wx.BoxSizer(wx.VERTICAL)

        #------------
        
        mainSizer.Add(self.pnl, 1, wx.EXPAND)

        #------------
        
        self.SetSizer(mainSizer)
        mainSizer.Layout()
        
#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()

