# sample_one.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

SCALE = 0.5

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    """
    Create a panel with a canvas to draw on.
    """
    
    def __init__(self, parent, size):
        wx.Panel.__init__(self, parent, -1, size=size)

        self.SetBackgroundStyle(wx.BG_STYLE_CUSTOM)

        #------------
        
        w, h = self.GetClientSize()

        #------------

        # Initial x position of image
        self.x = 440

        #------------
        
        self.timer = wx.Timer(self)
        # Start(int milliseconds, oneShot=False).
        # Lower timer interval gives faster speed.
        self.timer.Start(10)
        self.Bind(wx.EVT_TIMER, self.OnTimer, self.timer)

        #------------

        # Simplified init method.
        self.BindEvents()

    #-----------------------------------------------------------------------

    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        self.Bind(wx.EVT_SIZE, self.OnResize)
        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_ERASE_BACKGROUND, self.OnErase)
        # self.Bind(wx.EVT_MOUSE_EVENTS, self.OnMouseEvents)

        
    def OnMouseEvents(self, event): 
        """
        ...
        """
        
        if event.LeftDown() :
            self.timer.Stop()
        else:
            self.timer.Start()
        event.Skip()


    def OnErase(self, evt):
        """
        Noop because of double buffering.
        """
        
        pass

    
    def OnResize(self, event):
        """
        Refresh widget after resizing.
        """

        self.Refresh()
        event.Skip()


    def OnPaint(self, event=None):
        """
        Create the paint canvas.
        """

        dc = wx.BufferedPaintDC(self)
        brush = wx.Brush("#009fe3")
        dc.SetBackground(brush)
        dc.Clear()
        
        #------------
        
        font = dc.GetFont()
        font.SetWeight(wx.BOLD)
        font.SetPointSize(12)
        # font.SetFaceName("Tahoma") 
        dc.SetFont(font)

        #------------
        
        width, height = self.GetClientSize()

        #------------

        txt = "Loop for the text !!!"

        w, h = dc.GetTextExtent(txt)
        
        #------------

        # Draw to a bitmap and scale that.
        bmp = wx.Bitmap(width, h)
        mdc = wx.MemoryDC(bmp)
        brush = wx.Brush("#009fe3")
        mdc.SetBackground(brush)
        mdc.Clear()
        mdc.SetFont(font)
        mdc.SetTextForeground("white")
        mdc.DrawText(txt, int(self.x), 0)
        del mdc

        # wx.IMAGE_QUALITY_NEAREST, wx.IMAGE_QUALITY_BILINEAR,
        # wx.IMAGE_QUALITY_BICUBIC, wx.IMAGE_QUALITY_BOX_AVERAGE,
        # wx.IMAGE_QUALITY_NORMAL, wx.IMAGE_QUALITY_HIGH
        image = bmp.ConvertToImage()
        image = image.Scale(int(width*SCALE*2), int(height*SCALE*2), wx.IMAGE_QUALITY_HIGH)
        bmp = wx.Bitmap(image)
            
        dc.DrawBitmap(bmp, 0, 0)

        
    def OnTimer(self, event):
        """
        ...
        """

        w, h = self.GetClientSize()

        #------------
        
        # Increment x to start moving.
        self.x += -0.5
        # Optional continuous movement
        # experiment with wrap around values.
        if self.x > (w+100) or self.x < -w/2:
            self.x = w

        self.Refresh()

#---------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    """
    ...
    """
    
    def __init__(self):
        wx.Frame.__init__(self, None,
                          title="Horizontal news-ticker (image/scale)",
                          size=(400, 80))

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.DoLayout()

        #------------

        self.CenterOnScreen()

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetIcon(wx.Icon('icons/wxwin.ico'))
        self.SetMinSize((100, 80))
        self.SetBackgroundColour("yellow")


    def CreateCtrls(self):
        """
        ...
        """

        size = self.GetClientSize()

        self.pnl = MyPanel(self, size=size)


    def DoLayout(self):
        """
        ...
        """

        mainSizer = wx.BoxSizer(wx.VERTICAL)

        #------------
        
        mainSizer.Add(self.pnl, 1, wx.EXPAND)

        #------------
        
        self.SetSizer(mainSizer)
        mainSizer.Layout()
        
#---------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()

