# !/usr/bin/env python3
# -*- coding : utf-8 -*-

#-------------------------------------------------------------------------------
# Name       : sample_two.py
# Purpose    : Drop down panel example.
#
# Author     : ???
# Link       : wxPython forum.
# Created    : -
# Copyright  : -
# Licence    : -
#-------------------------------------------------------------------------------

"""

...

"""


#-------------------------------------------------------------------------------
# Import python packages
#-------------------------------------------------------------------------------
import os
import sys


#-------------------------------------------------------------------------------
# Import wxPython packages
#-------------------------------------------------------------------------------
import wx
import wx.lib.scrolledpanel as scrolled
import wx.lib.buttons as buttons


#-------------------------------------------------------------------------------
# wxPython version
#-------------------------------------------------------------------------------
print("wxPython version :", wx.VERSION_STRING)


#-------------------------------------------------------------------------------
# Path
#-------------------------------------------------------------------------------
app_dir = os.path.split(os.path.abspath(sys.argv[0]))[0]
icon_dir = os.path.join(app_dir, "icons")


#-------------------------------------------------------------------------------
# Class
#-------------------------------------------------------------------------------
# class MyWxExpandPanel
# class MyButtonPanel
# class MyAbsolute
# class MyFrame


#-------------------------------------------------------------------------------

class MyWxExpandPanel(wx.Panel):
    """
    A Custom DropDown Panel.
    """    
    def __init__(self, parent, title="Frame Layout", expand=False):
        wx.Panel.__init__(self, parent, wx.ID_ANY, style=wx.SUNKEN_BORDER)
        
        self.expand = expand # Expand status.
        self.parent = parent # Parent of this panel.
        self.title = title
                    
        # This will be the main sizer for this panel.
        self.vbox = wx.FlexGridSizer(100, 1, 3, 0)
        self.vbox.AddGrowableCol(0)
                
        # Create button for collapse/expand.     
        self.btn = buttons.GenBitmapTextButton(self, wx.ID_ANY,
                                               bitmap=wx.Bitmap("Bitmaps/img.png"),
                                               label=title,
                                               size=(200, -1),
                                               style=wx.ALIGN_LEFT,
                                               name="cpbtn")
        self.btn.SetUseFocusIndicator(True)
        self.btn.SetBezelWidth(2)
        # Define the button color.
        self.btn.SetBackgroundColour("#ff8080")
        self.btn.SetForegroundColour(wx.BLACK)

        self.btn.Bind(wx.EVT_BUTTON, self.onClick)
        
        self.vbox.Add(self.btn, 1, wx.EXPAND | wx.ALL, 0)        
        self.SetSizer(self.vbox)

    #---------------------------------------------------------------------------
        
    def addWidget(self, widget):
        """
        ...
        """
        
        self.vbox.Add(widget, 0, wx.GROW)
        if not self.expand:
            widget.Hide()          


    def addSizer(self, sizer):
        """
        ...
        """
        
        self.vbox.Add(sizer, 0, wx.EXPAND|wx.ALL, 1)
        if not self.expand:
            sizer.Hide()


    def onClick(self, event=None):
        """
        ...
        """
        
        self.update()
          

    def update(self):
        """
        ...
        """
        
        # Toggle the status of 'expand'.
        self.expand = not self.expand  
        
        # Either hide or show the children.
        for child in self.GetChildren():
            # Ignore button.
            if child.GetName() == "cpbtn":  continue
            # Do not show disabled widgets.
            #~ if child.IsEnabled():
                #~ child.Show(self.expand)
            #~ else:
                #~ child.Hide()
            child.Show(self.expand)
            
        # This works
        # self.parent.Layout()
        # make scrollbars visible if parent is scrolledWindow 
        # and if they are required automatically        
        # self.parent.SendSizeEvent() 
        # self.parent.Refresh()
        
        # This I am not sure.
        self.parent.SetupScrolling() 
        self.parent.Refresh()
        
#-------------------------------------------------------------------------------

class MyButtonPanel(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent, -1)
        
        b1 = wx.Button(self, -1, "Button-1")     
        b2 = wx.Button(self, -1, "Button-2")
        b3 = wx.Button(self, -1, "Button-3")
        
        vbox = wx.BoxSizer(wx.VERTICAL)
        vbox.Add(b1, 1)
        vbox.Add(b2, 1)
        vbox.Add(b3, 1)
        
        self.SetSizer(vbox)

#-------------------------------------------------------------------------------

class MyAbsolute(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent)
             
        self.parent = parent

        self.SetBackgroundColour("#c0c0c0")
        
        vbox = wx.BoxSizer(wx.VERTICAL)
        self.scp = scrolled.ScrolledPanel(self, wx.ID_ANY,
                                          style=wx.TAB_TRAVERSAL,
                                          name="panel")
        self.scpSizer = wx.BoxSizer(wx.VERTICAL)
                
        vbox.Add(self.scp, 1, wx.EXPAND)
        
        # Create MyWxExpandPanel.
        self.expandPanel = MyWxExpandPanel(self.scp, " Drop down panel - A", 0)
        self.expandPanel.SetBackgroundColour("#eceade")
        
        # Create Three button panel.
        btnPanel = MyButtonPanel(self.expandPanel)
        
        # Add btn panel to expandPanel.
        # This will add btnPanel to a sizer in expandPanel.
        self.expandPanel.addWidget(btnPanel)
        
        # Finally add expandPanel to scrollWindow.
        self.scpSizer.Add(self.expandPanel, 0, wx.EXPAND)
        
        # Create MyWxExpandPanel.
        self.expandPanel = MyWxExpandPanel(self.scp, " Drop down panel - B", 0)
        self.expandPanel.SetBackgroundColour("#eceade")
        
        # Create Three button panel.
        btnPanel = MyButtonPanel(self.expandPanel)
        
        # Add btn panel to expandPanel.
        # This will add btnPanel to a sizer in expandPanel.
        self.expandPanel.addWidget(btnPanel)
        
        # Finally add expandPanel to scrollWindow.
        self.scpSizer.Add(self.expandPanel, 0, wx.EXPAND)
        
        # Create MyWxExpandPanel.
        self.expandPanel = MyWxExpandPanel(self.scp, " Drop down panel - C", 0)
        self.expandPanel.SetBackgroundColour("#eceade")
        
        # Create Three button panel.
        btnPanel = MyButtonPanel(self.expandPanel)
        
        # Add btn panel to expandPanel.
        # This will add btnPanel to a sizer in expandPanel.
        self.expandPanel.addWidget(btnPanel)
        
        # Finally add expandPanel to scrollWindow.
        self.scpSizer.Add(self.expandPanel, 0, wx.EXPAND)
        
        # Create MyWxExpandPanel.
        self.expandPanel = MyWxExpandPanel(self.scp, " Drop down panel - D", 0)
        self.expandPanel.SetBackgroundColour("#eceade")
        
        # Create Three button panel.
        btnPanel = MyButtonPanel(self.expandPanel)
        
        # Add btn panel to expandPanel.
        # This will add btnPanel to a sizer in expandPanel.
        self.expandPanel.addWidget(btnPanel)
        
        # Finally add expandPanel to scrollWindow.
        self.scpSizer.Add(self.expandPanel, 0, wx.EXPAND)        
        
        self.scp.SetSizer(self.scpSizer)
        self.scp.SetAutoLayout(1)
        
        self.scp.SetupScrolling(scroll_x=False, scroll_y=True,
                                rate_y=10, scrollToTop=True)
        
        self.SetSizer(vbox)
        self.Layout()

#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, wx.ID_ANY,
                          title="Sample_two",
                          pos=wx.DefaultPosition,
                          size=(400, 250),
                          style=wx.DEFAULT_FRAME_STYLE)

        self.Bind(wx.EVT_CLOSE, self.onCloseWindow)
        
        self.panel = MyAbsolute(self)
        
        self.Centre()
        self.Show()

        #------------

        # Simplified init method.
        self.SetProperties()
        
    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the frame properties (title, icon...).
        """
        
        # Set frame icon. 
        frameicon = wx.Icon("icons/wxwin.ico")
        self.SetIcon(frameicon)
        
        
    def onClose(self, event):
        self.Close(True)


    def onCloseWindow(self, event):
        self.Destroy()

#-------------------------------------------------------------------------------
        
if __name__ == '__main__':
    app = wx.App()
    frame = MyFrame()
    frame.Show()
    app.MainLoop()
