# !/usr/bin/env python3
# -*- coding : utf-8 -*-

#-------------------------------------------------------------------------------
# Name       : sample_three.py
# Purpose    : Simple foldable panels. Layout lifted off Windows.
#              Use at your own risk!
# Author     : Egor
#              Modified and updated for wxPython Phoenix by Ecco
# Link       : wxPython forum.
# Created    : A long time ago...
# Copyright  : -
# Licence    : Code put in the public domain, for someone else
#              could find a use for it
#-------------------------------------------------------------------------------

"""

...

"""


#-------------------------------------------------------------------------------
# Import python packages
#-------------------------------------------------------------------------------
import os
import sys


#-------------------------------------------------------------------------------
# Import wxPython packages
#-------------------------------------------------------------------------------
import wx


#-------------------------------------------------------------------------------
# wxPython version
#-------------------------------------------------------------------------------
print("wxPython version :", wx.VERSION_STRING)


#-------------------------------------------------------------------------------
# Path
#-------------------------------------------------------------------------------
app_dir = os.path.split(os.path.abspath(sys.argv[0]))[0]
icon_dir = os.path.join(app_dir, "icons")
bmp_dir = os.path.join(app_dir, "bitmaps")


#-------------------------------------------------------------------------------
# Class
#-------------------------------------------------------------------------------
# class MyFoldPanel
# class MyColorPanel
# class MyMainPanel
# class MyFrame
# class MyApp


#-------------------------------------------------------------------------------

class MyFoldPanel(wx.Panel):
    def __init__(self, parent, psizer, title, tooltip=None,
                 rimcolour="light grey", bgcolour="white",
                 txtcolour="black", is_open=1):
        wx.Panel.__init__(self, parent, -1)

        #------------

        # Attributes
        self.is_open = is_open
        self.parent = parent
        self.rimcolour, self.bgcolour, self.txtcolour = rimcolour, bgcolour, txtcolour
        self.title = title
        self.tooltip = tooltip
        # XXX It won't work properly without
        # refreshing the parent sizer/panel.
        self.parentsizer = psizer
        
        #------------
        
        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()
        
    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the panel properties (color...).
        """

        self.SetBackgroundColour(self.rimcolour)
        

    def CreateCtrls(self):
        """
        Create some controls for my panel.
        """
        
        self.bmp_bu = wx.Bitmap(os.path.join(bmp_dir,  # bottom/open/state-1
                                             "sm_down.png"),
                                type=wx.BITMAP_TYPE_PNG)

        self.bmp_bd = wx.Bitmap(os.path.join(bmp_dir,  # bottom
                                             "sm_up.png"),
                                type=wx.BITMAP_TYPE_PNG)

        self.bmp_wu = wx.Bitmap(os.path.join(bmp_dir,  # top
                                             "sm_down.png"),
                                type=wx.BITMAP_TYPE_PNG)

        self.bmp_wd = wx.Bitmap(os.path.join(bmp_dir,  # top/close/state-2
                                             "sm_up.png"),
                                type=wx.BITMAP_TYPE_PNG)

        self.bmp_bub = wx.Bitmap(os.path.join(bmp_dir,  # bottom
                                              "sm_down.png"),
                                 type=wx.BITMAP_TYPE_PNG)        

        self.bmp_bdb = wx.Bitmap(os.path.join(bmp_dir,  # bottom/close/state-2
                                              "sm_up.png"),
                                 type=wx.BITMAP_TYPE_PNG)

        self.bmp_wub = wx.Bitmap(os.path.join(bmp_dir,  # top/open/state-1
                                              "sm_down.png"),
                                 type=wx.BITMAP_TYPE_PNG)

        self.bmp_wdb = wx.Bitmap(os.path.join(bmp_dir,  # top
                                              "sm_up.png"),
                                 type=wx.BITMAP_TYPE_PNG)
        
        #------------
        
        # Title panel.
        self.tpanel = wx.Panel(self, -1)
        if self.tooltip is not None:
            self.tpanel.SetToolTip(self.tooltip)
            
        self.title = wx.StaticText( self.tpanel, -1, self.title)
        self.title.SetFont(wx.Font(9, wx.SWISS, wx.NORMAL, wx.BOLD))
        self.title.SetForegroundColour(self.txtcolour)
        
        if self.is_open==1:
            if self.txtcolour == "black": bmp = self.bmp_bu
            else: bmp = self.bmp_wu
        else:
            if self.txtcolour == "black": bmp = self.bmp_bd
            else: bmp = self.bmp_wd

        self.sb = wx.StaticBitmap(self.tpanel, -1, bmp,
                                  size=(bmp.GetWidth(),
                                        bmp.GetHeight()))

        cursor = wx.Cursor(wx.CURSOR_HAND)
        self.tpanel.SetCursor(cursor)
        

    def BindEvents(self):
        """
        Bind all the events related to my panel.
        """

        self.title.Bind(wx.EVT_LEFT_UP, self.OnButton)
        self.sb.Bind(wx.EVT_LEFT_UP, self.OnButton)
        self.tpanel.Bind(wx.EVT_LEFT_UP, self.OnButton)
        self.tpanel.Bind(wx.EVT_ENTER_WINDOW, self.OnEnter)
        self.tpanel.Bind(wx.EVT_LEAVE_WINDOW, self.OnLeave)
        

    def DoLayout(self):
        """
        Do layout.
        """

        self.vbox = wx.BoxSizer(wx.VERTICAL)
        box = wx.BoxSizer(wx.HORIZONTAL)

        box.Add(self.title, 1, wx.EXPAND | wx.LEFT | wx.TOP, 5)
        box.Add(self.sb, 0, wx.ALL, 4)

        self.tpanel.SetSizer(box)

        self.vbox.Add(self.tpanel, 0, wx.EXPAND)

        # Page panel.
        self.ppanel = wx.Panel(self, -1)
        self.ppanel.SetBackgroundColour(self.bgcolour)

        self.pbox = wx.BoxSizer(wx.VERTICAL)
        self.pbox.Layout()
        self.ppanel.SetSizer(self.pbox)


        self.vbox.Add(self.ppanel, 1, wx.EXPAND | wx.BOTTOM | wx.LEFT | wx.RIGHT, 1)

        if self.is_open == 0:
            self.vbox.Hide(self.ppanel)

        self.vbox.Layout()
        self.SetSizer(self.vbox)
        
        
    def OnEnter(self,event):
        """
        ...
        """
        
        if self.txtcolour == "black":
            if self.is_open == 1: bmp = self.bmp_bub
            else: bmp = self.bmp_bdb
        else:
            if self.is_open == 1: bmp = self.bmp_wub
            else: bmp = self.bmp_wdb

        self.sb.SetBitmap(bmp)


    def OnLeave(self,event):
        """
        ...
        """
        
        if self.txtcolour == "black":
            if self.is_open == 1: bmp = self.bmp_bu
            else: bmp = self.bmp_bd
        else:
            if self.is_open == 1: bmp = self.bmp_wu
            else: bmp = self.bmp_wd

        self.sb.SetBitmap(bmp)


    def OnButton(self,event):
        """
        ...
        """
        
        if self.is_open == 1:
            self.vbox.Hide(self.ppanel)
            if self.txtcolour == "black": bmp = self.bmp_bdb
            else: bmp = self.bmp_wdb
        else:
            self.vbox.Show(self.ppanel)
            if self.txtcolour == "black": bmp = self.bmp_bub
            else: bmp = self.bmp_wub

        # Ugly, all three statements are needed
        # (only tested in windows, though)
        # self.parentsizer.RecalcSizes()
        self.parentsizer.Layout()
        self.parent.Refresh()

        self.sb.SetBitmap(bmp)
        self.is_open = 1-self.is_open
        event.Skip()


    def SetPage(self, page, setbg=0):
        """
        ...
        """
        
        page.Reparent(self.ppanel)
        self.page = page

        self.pbox.Add(page, 1, wx.EXPAND | wx.ALL, 5)
        self.pbox.Layout()

        if setbg:
            page.SetBackgroundColour(self.bgcolour)

#-------------------------------------------------------------------------------
            
class MyColorPanel(wx.Panel):
    def __init__(self, parent, color):
        wx.Panel.__init__(self, parent, -1, size=(-1, -1))

        #------------

        # Attributes
        self.color = color

        #------------
        
        # Simplified init method.
        self.SetProperties()

        itemList = ['item 1', 'item 2', 'item 3', 'item 4']
        
        self.txt = wx.StaticText(self, -1, "This is a sample text !")
        self.btn = wx.Button(self, -1, "&Button")
        self.chk = wx.CheckBox(self, -1, "&CheckBox") 
        self.chk.SetValue(True)
        self.rdb = wx.RadioBox(self, label="RadioBox :",
                               choices=itemList,
                               majorDimension=4,
                               style=wx.RA_SPECIFY_COLS)

        self.Bind(wx.EVT_BUTTON, self.OnButton, self.btn)
        self.Bind(wx.EVT_CHECKBOX, self.OnCheckBox, self.chk)
        self.Bind(wx.EVT_RADIOBOX, self.OnRadioBox, self.rdb)
        
        #-----------------

        colour = self.GetBackgroundColour()
        colour.Set(colour.Red(), colour.Green(), colour.Blue(),
                   wx.ALPHA_TRANSPARENT)
        self.btn.SetBackgroundColour(colour)
        #self.chk.SetBackgroundColour(colour)        
        #self.rdb.SetBackgroundColour(colour)
        
        #------------
        
        self.sizer = wx.BoxSizer(wx.VERTICAL)

        self.sizer.Add(self.txt, 0, wx.ALL, 5)
        self.sizer.Add(self.btn, 0, wx.ALL, 5)
        self.sizer.Add(self.chk, 0, wx.ALL, 5)
        self.sizer.Add(self.rdb, 0, wx.ALL, 5)
        
        #------------

        self.SetSizer(self.sizer)
        self.sizer.Layout()
  
    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the panel properties (color...).
        """

        self.SetBackgroundColour(self.color)


    def OnButton(self, event):
        """
        ...
        """

        print("\nOnButton: %s" % event.GetId())
        
        checkBox = event.GetEventObject()
        label = checkBox.GetLabel()
        print("OnButton label: %s" % label)
        

    def OnCheckBox(self, event):
        """
        ...
        """

        print("\nOnCheckBox checked: %d" % event.IsChecked())
        
        checkBox = event.GetEventObject()
        val = checkBox.GetValue()
        print("OnCheckBox value: %s" % val)
        

    def OnRadioBox(self, event):
        """
        ...
        """

        print("\nOnRadioBox int: %d" % event.GetInt())
        
        radioBox = event.GetEventObject()
        select = radioBox.GetStringSelection()
        print("OnRadioBox get string selection: %s\n" % select)
        
#-------------------------------------------------------------------------------
            
class MyMainPanel(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent, -1)

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.DoLayout()

    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the panel properties (color...).
        """

        self.SetBackgroundColour("white")


    def CreateCtrls(self):
        """
        Create some controls for my panel.
        """

        # self.vbox is the top-level one that manages everything.        
        self.vbox = wx.BoxSizer(wx.VERTICAL)

        #------------
        
        tooltip = "Click to unfold the green panel"
        self.p1 = MyFoldPanel(self, self.vbox, "Green Panel",
                              tooltip, wx.Colour(10, 10, 96),
                              "white", "white", is_open=0)

        tooltip = "The titlebar arrow icon is only available in two colours\n"\
                  "... but is transparent."
        self.p2 = MyFoldPanel(self, self.vbox, "Red Panel",
                              tooltip, "light grey", "white",
                              "black", is_open=1)

        self.p1.SetPage(MyColorPanel(self.p1, wx.Colour(128, 255, 128)), 0)
        self.p2.SetPage(MyColorPanel(self.p2, wx.Colour(255, 128, 128)), 0)


    def DoLayout(self):
        """
        Do layout.
        """
     
        self.vbox.Add(self.p1, 0, wx.EXPAND | wx.ALL, 5)
        self.vbox.Add(self.p2, 0, wx.EXPAND | wx.ALL, 5)

        #------------

        self.SetSizer(self.vbox)
        self.vbox.Layout()
        
#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, pos=wx.DefaultPosition, size=(300, 305)):
        wx.Frame.__init__(self, None, -1, "", pos, size)

        #------------
        
        self.CreateStatusBar()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()

    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the frame properties (title, icon...).
        """

        self.SetTitle("Sample_three")

        #------------

        frm_icon = wx.Icon(os.path.join(icon_dir,
                                        "wxwin.ico"),
                           type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frm_icon)
        

    def CreateCtrls(self):
        """
        Make widgets for my frame.
        """

        self.pnl = MyMainPanel(self)
        
#-------------------------------------------------------------------------------
    
class MyApp(wx.App):
    def OnInit(self):

        #------------

        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#-------------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()
    
#-------------------------------------------------------------------------------

if __name__ == "__main__" :
    main()

