# !/usr/bin/env python3
# -*- coding : utf-8 -*-

#-------------------------------------------------------------------------------
# Name       : sample_one.py
# Purpose    : Simple foldable panels.
#
# Author     : Seaba & Komoto48g
# Link       : https://discuss.wxpython.org/t/interactive-panel-resizing/35557
# Created    : -
# Copyright  : -
# Licence    : -
#-------------------------------------------------------------------------------

"""

...

"""


#-------------------------------------------------------------------------------
# Import python packages
#-------------------------------------------------------------------------------
import os
import sys


#-------------------------------------------------------------------------------
# Import wxPython packages
#-------------------------------------------------------------------------------
import wx


#-------------------------------------------------------------------------------
# wxPython version
#-------------------------------------------------------------------------------
print("wxPython version :", wx.VERSION_STRING)


#-------------------------------------------------------------------------------
# Path
#-------------------------------------------------------------------------------
app_dir = os.path.split(os.path.abspath(sys.argv[0]))[0]
icon_dir = os.path.join(app_dir, "icons")


#-------------------------------------------------------------------------------
# Class
#-------------------------------------------------------------------------------
# class MyFoldPanel
# class MyFrame
# class MyApp


#-------------------------------------------------------------------------------

class MyFoldPanel(wx.Panel):
    def __init__(self, parent, label):
        wx.Panel.__init__(self, parent, size=(-1, 95))

        self.parent = parent
        
        self.SetBackgroundColour(wx.Colour(255, 100, 100))
        
        self.btn = wx.Button(self, label = f"Pane {label}")
        self.btn.Bind(wx.EVT_BUTTON, self.OnBtn)

        #-----------------

        colour = self.GetBackgroundColour()
        colour.Set(colour.Red(), colour.Green(), colour.Blue(),
                   wx.ALPHA_TRANSPARENT)
        self.SetBackgroundColour(colour)

        self.btn.SetForegroundColour(self.GetForegroundColour())
        
    #---------------------------------------------------------------------------
        
    def OnBtn(self, event):
        w, h = self.btn.GetSize()
        
        y = self.GetSize()[1]
        if y == 95:   self.SetMinSize([-1, h])
        else:          self.SetMinSize([-1, 95])
        self.Parent.Layout()    


    def DetachAll(self):
        self.sizer.Clear()


    def AttachAll(self):
        for panel in self.panels:
            self.sizer.Add(panel, 0, wx.EXPAND | wx.ALL, 5)

#-------------------------------------------------------------------------------
            
class MyFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None)

        #------------

        # Simplified init method.
        self.SetProperties()

        #------------
        
        self.panel = wx.Panel(self)
        self.panel.SetBackgroundColour(wx.Colour(100, 100, 200))
        self.sizer = wx.BoxSizer(wx.VERTICAL)

        self.panels = []
        for i in range(5):
            self.panels.append(MyFoldPanel(self.panel, i))
            self.sizer.Add(self.panels[-1], 0, wx.EXPAND | wx.ALL, 5)

        self.panel.SetSizer(self.sizer)

    #---------------------------------------------------------------------------
        
    def SetProperties(self):
        """
        Set the frame properties (title, icon...).
        """

        self.SetTitle("Sample_one")

        #------------

        frm_icon = wx.Icon(os.path.join(icon_dir,
                                        "wxwin.ico"),
                           type=wx.BITMAP_TYPE_ICO)
        self.SetIcon(frm_icon)
        
#-------------------------------------------------------------------------------
        
if __name__ == '__main__':
    app = wx.App()
    frame = MyFrame()
    frame.Show()
    app.MainLoop()
