# !/usr/bin/env python3
# -*- coding : utf-8 -*-

#-------------------------------------------------------------------------------
# Name       : sample_four.py
# Purpose    : Simple foldable panels.
# Author     : Ecco
# Created    : 02/08/22 (d/m/y)
# Copyright  : (c) 2022-2024
# Licence    : wxWindows license
#-------------------------------------------------------------------------------

"""

...

"""


#-------------------------------------------------------------------------------
# Import wxPython packages
#-------------------------------------------------------------------------------
import wx
import wx.lib.mixins.inspection  # Ctrl+Alt+I


#-------------------------------------------------------------------------------
# Event ID'S
#-------------------------------------------------------------------------------
ID_BTN_ONE   = wx.NewIdRef()
ID_BTN_TWO   = wx.NewIdRef()
ID_BTN_THREE = wx.NewIdRef()
ID_BTN_FOUR  = wx.NewIdRef()
ID_BTN_CLOSE = wx.NewIdRef()


#-------------------------------------------------------------------------------
# Constant
#-------------------------------------------------------------------------------
__APP_TITLE__   = "Sample_four"
__APP_VERSION__ = "1.0.0"


#-------------------------------------------------------------------------------
# wxPython version
#-------------------------------------------------------------------------------
print("wxPython version :", wx.VERSION_STRING)


#-------------------------------------------------------------------------------
# Class
#-------------------------------------------------------------------------------
# class MyPanel
# class MyFrame
# class MyApp


#-------------------------------------------------------------------------------

class MyPanel(wx.Panel):
    """
    Main panel for my widgets.
    """ 
    def __init__(self, parent,):
        wx.Panel.__init__(self, parent)

        #------------
        
        self.parent = parent

        #------------
        
        self.SetDoubleBuffered(True)
        
#-------------------------------------------------------------------------------
        
class MyFrame(wx.Frame):
    """
    We simply derive a new class of frame.
    """
    def __init__(self, parent, id, title=""):
        super(MyFrame, self).__init__(parent, id, title)

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()
        
        #------------
        
        self.Centre()

    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the frame properties (title, icon...).
        """
        
        # Set frame icon. 
        frameicon = wx.Icon("icons/wxwin.ico")
        self.SetIcon(frameicon)

        #------------

        # Set frame title.
        appName = "%s" % (wx.GetApp().GetAppName())
        appVersion = "%s" % (__APP_VERSION__)
        self.SetTitle("{} v{}".format(appName, appVersion))

        #------------

        # Set frame foreground and background.         
        # dark orange | cornflower blue
        # yellow green | yellow | wheat4
        self.SetBackgroundColour("#eceade") 
        self.SetForegroundColour("black")

        self.SetSize(300, -1)
        self.SetMaxSize((300, -1))
        self.SetMinSize((300, -1))


    def CreateCtrls(self):
        """
        Create some controls for my frame.
        """

        self.panel = MyPanel(self)

        #-----------------

        # A font can be retrieved from the OS default font
        # and modified.
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font.SetStyle(wx.NORMAL)
        font.SetWeight(wx.BOLD)
        
        #-----------------

        self.btn1 = wx.Button(self.panel,
                              ID_BTN_ONE,
                              "Pane 1")
        # Thank you da-dada !
        self.btn1.SetLabelMarkup(''.join(('<b>', '&First pane', '</b>')))
        
        self.sz1 = wx.StaticBoxSizer(wx.VERTICAL,
                                     self.panel,
                                     label="")
             
        self.szb1 = self.sz1.GetStaticBox()
        self.szb1.Show(not self.szb1.IsShown())

        itemList = ['item 1', 'item 2', 'item 3', 'item 4']

        self.rdb1 = wx.RadioBox(self.szb1, label="RadioBox :",
                                choices=itemList,
                                majorDimension=4,
                                style=wx.RA_SPECIFY_COLS)
        
        self.sz1.Add(self.rdb1, 0, 0)
        
        #-----------------

        self.btn2 = wx.Button(self.panel,
                              ID_BTN_TWO,
                              "Pane 2")
        self.btn2.SetLabelMarkup(''.join(('<b>', '&Second pane', '</b>')))
        
        self.sz2 = wx.StaticBoxSizer(wx.VERTICAL,
                                     self.panel,
                                     label="")
       
        self.szb2 = self.sz2.GetStaticBox()
        self.szb2.Show(not self.szb2.IsShown())
        
        self.rdb2 = wx.RadioBox(self.szb2, label="RadioBox :",
                                choices=itemList,
                                majorDimension=4,
                                style=wx.RA_SPECIFY_COLS)
        
        self.sz2.Add(self.rdb2, 0, 0)

        #-----------------

        self.btn3 = wx.Button(self.panel,
                              ID_BTN_THREE,
                              "Pane 3")
        self.btn3.SetLabelMarkup(''.join(('<b>', '&Third pane', '</b>')))
        
        self.sz3 = wx.StaticBoxSizer(wx.VERTICAL,
                                     self.panel,
                                     label="")
           
        self.szb3 = self.sz3.GetStaticBox()
        self.szb3.Show(not self.szb3.IsShown())
        
        self.rdb3 = wx.RadioBox(self.szb3, label="RadioBox :",
                                choices=itemList,
                                majorDimension=4,
                                style=wx.RA_SPECIFY_COLS)
        
        self.sz3.Add(self.rdb3, 0, 0)
        
        #-----------------

        self.btn4 = wx.Button(self.panel,
                              ID_BTN_FOUR,
                              "Pane 4")
        self.btn4.SetLabelMarkup(''.join(('<b>', 'F&ourth pane', '</b>')))
        
        self.sz4 = wx.StaticBoxSizer(wx.VERTICAL,
                                     self.panel,
                                     label="")

       
        self.szb4 = self.sz4.GetStaticBox()
        self.szb4.Show(not self.szb4.IsShown())
        
        self.rdb4 = wx.RadioBox(self.szb4, label="RadioBox :",
                                choices=itemList,
                                majorDimension=4,
                                style=wx.RA_SPECIFY_COLS)
        
        self.sz4.Add(self.rdb4, 0, 0)

        #-----------------

        colour = self.GetBackgroundColour()
        colour.Set(colour.Red(), colour.Green(), colour.Blue(),
                   wx.ALPHA_TRANSPARENT)
        self.SetBackgroundColour(colour)

        self.btn1.SetForegroundColour(self.GetForegroundColour())
        self.btn2.SetForegroundColour(self.GetForegroundColour())
        self.btn3.SetForegroundColour(self.GetForegroundColour())
        self.btn4.SetForegroundColour(self.GetForegroundColour())
        

    def BindEvents(self):
        """
        Bind all the events related to my frame.
        """

        self.Bind(wx.EVT_CHAR_HOOK, self.OnKeyUp)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
        self.btn1.Bind(wx.EVT_BUTTON, self.OnButton)
        self.btn2.Bind(wx.EVT_BUTTON, self.OnButton)
        self.btn3.Bind(wx.EVT_BUTTON, self.OnButton)
        self.btn4.Bind(wx.EVT_BUTTON, self.OnButton)

        self.panel.Bind(wx.EVT_RIGHT_UP, self.OnCloseWindow)  # Panel right clic.
        

    def DoLayout(self):
        """
        Do layout.
        """

        self.panelSizer = wx.BoxSizer(wx.VERTICAL)
        self.panelSizer.Add(self.btn1, proportion=0, flag=wx.EXPAND)
        self.panelSizer.Add(self.sz1, proportion=1, flag=wx.EXPAND)
        self.panelSizer.Add(self.btn2, proportion=0, flag=wx.EXPAND)
        self.panelSizer.Add(self.sz2, proportion=1, flag=wx.EXPAND)
        self.panelSizer.Add(self.btn3, proportion=0, flag=wx.EXPAND)
        self.panelSizer.Add(self.sz3, proportion=1, flag=wx.EXPAND)
        self.panelSizer.Add(self.btn4, proportion=0, flag=wx.EXPAND)
        self.panelSizer.Add(self.sz4, proportion=1, flag=wx.EXPAND)

        self.panel.SetSizer(self.panelSizer)

        #------------
        
        mainSizer = wx.BoxSizer()
        mainSizer.Add(self.panel, proportion=1, flag=wx.EXPAND)

        #------------
        
        self.SetSizer(mainSizer)
        self.Fit()


        
    def OnButton(self, evt):
        """
        ...
        """
        
        event_id = evt.GetId()

        #------------
                
        if event_id == ID_BTN_ONE :
            self.szb1.Show(not self.szb1.IsShown())

        elif event_id == ID_BTN_TWO :
            self.szb2.Show(not self.szb2.IsShown())

        elif event_id == ID_BTN_THREE :
            self.szb3.Show(not self.szb3.IsShown())

        elif event_id == ID_BTN_FOUR :
            self.szb4.Show(not self.szb4.IsShown())
            
        self.panelSizer.Fit(self)


    def OnKeyUp(self, event):
        """
        ...
        """

        if event.GetKeyCode() == wx.WXK_ESCAPE:
            # Close the frame, no action.
            self.OnCloseWindow(event)
        event.Skip()


    def OnBtnClose(self, event):
        """
        ...
        """

        self.Close()

        
    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        
#---------------------------------------------------------------------------
        
class MyApp(wx.App, wx.lib.mixins.inspection.InspectionMixin):
    """
    We create an application object.
    """
    def OnInit(self):

        #------------
        
        # Initialize the inspection tool.
        self.Init()
        
        #------------
        
        self.SetAppName(__APP_TITLE__)

        #------------
        
        frame = MyFrame(parent=None, id=-1, title="")
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()
    
#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
