# sample_two.py

import sys
import os
import wx

# class MyCaptionBox
# class MyDialog
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyCaptionBox(wx.Panel):
    """
    ...
    """ 
    def __init__(self, parent, caption):
        """
        ...
        """
        super(MyCaptionBox, self).__init__(parent,
                                           style=wx.NO_BORDER |
                                           wx.TAB_TRAVERSAL)

        #------------
        
        # Attributes.
        self._caption = caption
        self._csizer = wx.BoxSizer(wx.VERTICAL)

        #------------
        
        # Simplified init method.
        self.BindEvents()
        self.DoLayout()

    #-----------------------------------------------------------------------
       
    def BindEvents(self):
        """
        Binds the events to specific methods.
        """

        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_SIZE, self.OnSize)

        
    def DoLayout(self):
        """
        ...
        """
        
        msizer = wx.BoxSizer(wx.HORIZONTAL)
        self._csizer.AddSpacer(25)     # Extra space for caption.
        msizer.Add(self._csizer, 0, wx.EXPAND|wx.ALL, 15)
        self.SetSizer(msizer)


    def DoGetBestSize(self):
        """
        ...
        """

        self.Refresh()
        
        size = super(MyCaptionBox, self).DoGetBestSize()
        
        # Compensate for wide caption labels.
        tw = self.GetTextExtent(self._caption)[0]
        size.SetWidth(max(size.width, tw))  # Box width.
        
        return size


    def AddItem(self, item):
        """
        Add a window or sizer item to the settingCaptionBox.
        """
        
        self._csizer.Add(item, 0, wx.ALL, 5)


    def OnSize(self, event):
        """
        ...
        """
        
        event.Skip()
        self.Refresh()

        
    def OnPaint(self, event):
        """
        Draws the Caption and border around the controls.
        """
        
        dc = wx.BufferedPaintDC(self)
        dc.Clear()
        gcdc = wx.GCDC(dc)

        gc = gcdc.GetGraphicsContext()
        
        # Get the working rectangle we can draw in.
        rect = self.GetClientRect()

        # Get the sytem color to draw the caption.
        ss = wx.SystemSettings
        color = "#760000" 
        txtcolor = ss.GetColour(wx.SYS_COLOUR_HIGHLIGHTTEXT)
        gcdc.SetTextForeground(txtcolor)

        # Font, size and style for the caption.
        font = self.GetFont().GetPointSize()
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT) 
        font.SetWeight(wx.BOLD)
        
        # Draw the border.
        rect.Inflate(-10, -10)
        # Stroke color and thickness.
        gcdc.SetPen(wx.Pen(color, 2, wx.SOLID))
        gcdc.SetBrush(wx.TRANSPARENT_BRUSH)
        gcdc.DrawRectangle(rect)

        # Gradient caption (red ---> black).
        color1 = wx.Colour(255, 0, 0)
        color2 = wx.Colour(0, 0, 0)
        x1, y1 = rect.x, rect.y
        y2 = y1 + 25

        gradbrush = gc.CreateLinearGradientBrush(x1, y1,
                                                 x1, y2,
                                                 color1,
                                                 color2)
        gc.SetBrush(gradbrush)

        # Add the caption.
        rect = wx.Rect(rect.x, rect.y,
                       rect.width, 26)  # Caption size.
        dc.SetBrush(wx.Brush(color))
        gcdc.DrawRectangle(rect)
        rect.Inflate(-5, 0)
        gcdc.SetFont(font)
        gcdc.DrawLabel(self._caption, rect, wx.ALIGN_CENTER)

#---------------------------------------------------------------------------
        
class MyDialog(wx.Dialog):
    """
    ...
    """  
    def __init__(self, parent, title,
                 pos=wx.DefaultPosition,
                 size=wx.DefaultSize):
        wx.Dialog.__init__(self,
                           parent,
                           -1,
                           title,
                           pos=(-1, -1),
                           size=(420, 550),
                           style=wx.DEFAULT_FRAME_STYLE)

        #------------

        # Attributes.        
        self.parent = parent
         
        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.DoLayout()
        
        #------------
            
        self.CenterOnScreen(wx.BOTH)
        print("\nDisplay the caption box dialog")

        #------------
        
        self.ShowModal()
        self.Destroy()
        
    #-----------------------------------------------------------------------
         
    def SetProperties(self):
        """
        ...
        """
        
        frameicon = wx.Icon("icon_wxWidgets.ico")
        self.SetIcon(frameicon)

        self.SetMinSize((420, 550))
        

    def CreateCtrls(self):
        """
        ...
        """
        
        self.firstBox = MyCaptionBox(self, "First caption")

        # Create some static text in the box.
        for x in range(4):
            st = wx.StaticText(self.firstBox,
                               label="- blah, blah, blah, blah... %d" % x)
            self.firstBox.AddItem(st)

        #------------
        
        self.secondBox = MyCaptionBox(self, "Second caption")

        # Create some static text in the box.
        for x in range(4):
            st = wx.StaticText(self.secondBox,
                               label="- blah, blah, blah, blah... %d" % x)
            self.secondBox.AddItem(st)

        #------------
        
        self.thirdBox = MyCaptionBox(self, "Third caption")

        # Create some static text in the box.
        for x in range(4):
            st = wx.StaticText(self.thirdBox,
                               label="- blah, blah, blah, blah... %d" % x)
            self.thirdBox.AddItem(st)
        
        #------------
        
        self.btnSizer = self.CreateButtonSizer(wx.OK | wx.CANCEL)        
         
        
    def DoLayout(self):
        """
        ...
        """

        mainSizer = wx.BoxSizer(wx.HORIZONTAL)        
        ctrlSizer = wx.BoxSizer(wx.VERTICAL)

        ctrlSizer.Add(self.firstBox, 1, wx.EXPAND)
        ctrlSizer.Add(self.secondBox, 1, wx.EXPAND)
        ctrlSizer.Add(self.thirdBox, 1, wx.EXPAND)
        ctrlSizer.Add(self.btnSizer, 0, wx.EXPAND |
                      wx.RIGHT, 5)

        mainSizer.Add(ctrlSizer, 1, wx.EXPAND |
                      wx.BOTTOM, 10)
        
        self.SetSizer(mainSizer)
        mainSizer.Layout()
    
#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    ...
    """        
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")
        
        #------------

        # Return application name.
        self.app_name = wx.GetApp().GetAppName()

        #------------
        
        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------
        
        self.CenterOnScreen()
        
    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle(self.app_name)

        #------------
        
        frameicon = wx.Icon("icon_wxWidgets.ico")
        self.SetIcon(frameicon)
        
        
    def CreateCtrls(self):        
        """
        ...
        """

        # Create a panel.
        self.panel = wx.Panel(self, -1)

        #------------
        
        # Add some buttons.       
        self.btnDlg = wx.Button(self.panel,
                                -1,
                                "&Show caption box dialog")

        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")
        

    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind the close event to an event handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
        # Bind the buttons event to an event handler.
        self.Bind(wx.EVT_BUTTON, self.OnSetting, self.btnDlg)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)
        
        
    def DoLayout(self):
        """
        ...
        """
        
        # MainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)        
        # wx.BoxSizer(sizer, proportion, flag, border) 
        mainSizer.Add(self.btnDlg, 1, wx.EXPAND | wx.ALL, 10)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)
        
        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)

    #-----------------------------------------------------------------------
        
    def OnCloseMe(self, event):
        """
        ...
        """
        
        self.Close(True)


    def OnSetting(self, event):
        """
        ...
        """
        
        settingDlg = MyDialog(self,
                              title="Caption box dialog")
                              #pos=(-1, -1),
                              #size=(500, 300))
        
    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()

#---------------------------------------------------------------------------
      
class MyApp(wx.App):
    """
    ...
    """  
    def OnInit(self):

        #------------

        self.SetAppName("Main frame")

        #------------
        
        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------
        
        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Returns the installation directory for my application.
        """
        
        return self.installDir

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
