# sample_two.py

import wx
try:
    from agw import hyperlink as hl
except ImportError:
    # If it's not there locally, try the wxPython lib.
    import wx.lib.agw.hyperlink as hl

# class MyAboutDlg
# class MyFrame
# class MyApp

#-------------------------------------------------------------------------------
    
class MyAboutDlg(wx.Dialog):
    """
    ...
    """
    def __init__(self,
                 parent,
                 title,
                 icon1=None,
                 icon2=None,
                 short_name=None,
                 long_name=None,
                 version=None,
                 description=None,
                 urls=None,
                 licence=None,
                 developers=[]):
        wx.Dialog.__init__(self, parent, title=title)

        self.icon1 = icon1
        self.icon2 = icon2
        self.short_name = short_name
        self.long_name = long_name
        self.version = version
        self.version = version
        self.description = description
        self.urls = urls
        self.licence = licence
        self.developers = developers

        #------------

        # Simplified init method.
        self.Build()

        #------------
        
        self.CenterOnParent()
        
    #---------------------------------------------------------------------------
        
    def Build(self):
        """
        ...
        """
        
        # Build the header.
        header = wx.BoxSizer(wx.HORIZONTAL)
        
        if self.icon1:
            header.Add(wx.StaticBitmap(self, bitmap=self.icon1), 0)
        else:
            header.Add((64, 64))
        header.Add((20, 1), 1)

        if self.short_name:
            label = wx.StaticText(self, label=self.short_name)
            of = label.GetFont()
            font = wx.Font(int(of.GetPointSize() * 2), of.GetFamily(), wx.NORMAL, wx.FONTWEIGHT_BOLD)
            label.SetFont(font)
            header.Add(label, 0, wx.ALL|wx.ALIGN_CENTER_VERTICAL, 5)
        else:
            header.Add((1, 1), 1)
        header.Add((20, 1), 1)

        if self.icon2:
            header.Add(wx.StaticBitmap(self, bitmap=self.icon2), 0)
        else:
            header.Add((64, 64))
        width = header.MinSize[0]

        #------------
        
        # Now the rest.
        mainSizer = wx.BoxSizer(wx.VERTICAL)       
        mainSizer.Add(header, 0, wx.ALIGN_CENTER|wx.ALL, 5)

        #------------
        
        if self.long_name:
            label = wx.StaticText(self, label=self.long_name)
            # label.SetForegroundColour("gray")
            of = label.GetFont()
            font = wx.Font(int(of.GetPointSize() * 1.5), of.GetFamily(), wx.NORMAL, wx.NORMAL)
            label.SetFont(font)
            mainSizer.Add(label, 0, wx.TOP|wx.RIGHT|wx.LEFT|wx.ALIGN_CENTER, 5)
            width = max(width, label.Size[0])

        #------------
            
        if self.version:
            label = wx.StaticText(self, label="Version : " + self.version)
            label.SetForegroundColour("red")
            # of = label.GetFont()
            # font = wx.Font(int(of.GetPointSize() * 1.5), of.GetFamily(), wx.NORMAL, wx.NORMAL)
            # label.SetFont(font)
            mainSizer.Add(label, 0, wx.BOTTOM|wx.ALIGN_CENTER, 5)

        #------------
            
        if self.description:
            label = wx.StaticText(self, label=self.description)
            # label.SetForegroundColour("gray")
            # of = label.GetFont()
            # font = wx.Font(int(of.GetPointSize() * 1.5), of.GetFamily(), wx.NORMAL, wx.NORMAL)
            # label.SetFont(font)           
            label.Wrap(max(250, int(0.9*width)))
            mainSizer.Add(label, 0, wx.ALL|wx.ALIGN_CENTER, 5)

        #------------
            
        if self.licence:
            label = wx.StaticText(self, label="License :")
            # label.SetForegroundColour("gray")
            of = label.GetFont()
            font = wx.Font(of.GetPointSize(), of.GetFamily(), wx.NORMAL, wx.BOLD)
            label.SetFont(font)
            mainSizer.Add(label, 0, wx.ALL|wx.ALIGN_LEFT, 5)
            label = wx.StaticText(self, label=self.licence)
            label.SetForegroundColour("gray")
            label.Wrap(max(250, int(0.9*width)))
            mainSizer.Add(label, 0, wx.ALL|wx.ALIGN_CENTER, 2)

        #------------
            
        if self.developers:
            label = wx.StaticText(self, label="Developed by :")
            # label.SetForegroundColour("gray")
            of = label.GetFont()
            font = wx.Font(of.GetPointSize(), of.GetFamily(), wx.NORMAL, wx.BOLD)
            label.SetFont(font)
            mainSizer.Add(label, 0, wx.ALL|wx.ALIGN_LEFT, 5)
           
            for developer in self.developers:
                label = wx.StaticText(self, label="          " + developer)
                label.SetForegroundColour("gray")
                mainSizer.Add(label, 0, wx.ALL|wx.ALIGN_LEFT, 0)

        #------------
                
        if self.urls:            
            label = wx.StaticText(self, label="For more information :")
            # label.SetForegroundColour("gray")
            of = label.GetFont()
            font = wx.Font(of.GetPointSize(), of.GetFamily(), wx.NORMAL, wx.BOLD)
            label.SetFont(font)
            mainSizer.Add(label, 0, wx.ALL|wx.ALIGN_LEFT, 5)
            for url in self.urls:
                link = hl.HyperLinkCtrl(self, wx.ID_ANY,
                          label=url,
                          URL=url)
                mainSizer.Add(link, 0, wx.ALL|wx.ALIGN_CENTER, 2)

        #------------
                
        mainSizer.Add((1, 5), 1)
        mainSizer.Add(wx.Button(self, id=wx.ID_OK, label="&Dismiss"), 0, wx.ALL|wx.ALIGN_RIGHT,5)
        spaceSizer = wx.BoxSizer(wx.VERTICAL)
        spaceSizer.Add(mainSizer, 0, wx.ALL, 10)
        self.SetSizerAndFit(spaceSizer)

#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    ...
    """
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")

        #------------

        # Return application name.
        self.app_name = wx.GetApp().GetAppName()

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen()

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle(self.app_name)

        #------------

        frameicon = wx.Icon("icon_wxWidgets.ico")
        self.SetIcon(frameicon)


    def CreateCtrls(self):
        """
        ...
        """

        # Create a panel.
        self.panel = wx.Panel(self, -1)

        #------------

        # Add some buttons.
        self.btnDlg = wx.Button(self.panel,
                                -1,
                                "&Show customized about dialog")

        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")


    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind the close event to an event handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

        # Bind the buttons event to an event handler.
        self.Bind(wx.EVT_BUTTON, self.OnAboutDlg, self.btnDlg)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)


    def DoLayout(self):
        """
        ...
        """

        # mainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)
        # wx.BoxSizer(sizer, proportion, flag, border)
        mainSizer.Add(self.btnDlg, 1, wx.EXPAND | wx.ALL, 10)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)

    #-----------------------------------------------------------------------

    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)


    def OnAboutDlg(self, event):
        """
        ...
        """

        aboutDlg = MyAboutDlg(self,
                              title="Customized about dialog",
                              icon1=wx.Bitmap("Images/wxWidgets.png"),
                              icon2=wx.Bitmap("Images/wxPython.png"),
                              short_name='Acronym',
                              long_name='A longer name for the program',
                              version = "1.2.3",
                              description="A description of the program. This could be a pretty long bit of text. How shall I know how long to make it ? How will it fit in ?",
                              urls = ["http://www.some.website.org/", "mailto:someone@somwewhere.com"],
                              licence="This is a short description of the license used for the program.",
                              developers = ["A developer", "Another developer"])
    
        aboutDlg.ShowModal()
        
    
    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()

#-------------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        self.locale = wx.Locale(wx.LANGUAGE_ENGLISH)

        #------------

        self.SetAppName("Main frame")

        #------------

        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
