# sample_three.py

# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Generated by wxGlade 0.4.1cvs on Thu Jun 7 21:24:31 2007 
# from /home/stani/sync/python/convert/trunk/about.wxg

# Auto generated so no pep 8.

# Updated for Python 3 and wxPython Phoenix by Ecco.

import sys
import wx
import random
import wx.lib.agw.hyperlink as hl
import wx.lib.dialogs

_ = wx.GetTranslation

# def create_credits
# class MyTransparentBitmap
# class WxgAboutDialog
# class WxgCreditsDialog
# class MyCreditsDialog
# class MyDialog
# class MyApp

#---------------------------------------------------------------------------

def create_credits(*args):
    """
    ...
    """
            
    result  = {}
    for arg in args:
        result[arg] = [{
                        'name':'%s %d' % (arg, x),
                        'email':'info@%s%d.com' % (arg, x)}
                        for x in range(random.randint(1, 9))]

    return result
    
#---------------------------------------------------------------------------

if sys.platform.startswith('win'):
    class MyTransparentBitmap(wx.Panel):
        def __init__(self, parent, id, bitmap=wx.NullBitmap, *args, **keyw):
            super(MyTransparentBitmap, self).__init__(parent, id, *args, **keyw)

            self.SetBitmap(bitmap)

            self.Bind(wx.EVT_PAINT, self.OnPaint)

        #-------------------------------------------------------------------
            
        def SetBitmap(self, bitmap):
            """
            ...
            """
            
            self._bitmap = bitmap

            size = self._bitmap.GetSize()
            self.SetSize(size)
            self.SetMinSize(size)

            self.GetParent().Layout()


        def OnPaint(self, evt):
            """
            ...
            """
            
            dc = wx.PaintDC(self)
            dc.SetBackground(wx.Brush(self.GetParent().GetBackgroundColour()))
            dc.Clear()
            dc.DrawBitmap(self._bitmap, 0, 0, True)

else:
    MyTransparentBitmap = wx.StaticBitmap

#---------------------------------------------------------------------------
    
class WxgAboutDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)

        self.logo = MyTransparentBitmap(self, -1, wx.NullBitmap)
        
        self.title = wx.StaticText(self, -1,
                                   _("Program Version"),
                                   style=wx.ALIGN_CENTRE)
        
        self.description = wx.StaticText(self, -1, _("Description"))
        
        self.website = hl.HyperLinkCtrl(self, -1,
                                        label = "http://www.stani.be",
                                        URL = "http://www.stani.be")
        
        self.credits = wx.Button(self, -1, _("C&redits"))
        self.license = wx.Button(self, -1, _("&License"))
        self.close = wx.Button(self, wx.ID_CLOSE, _("&Close"))

        #------------

        # Simplified init method.        
        self.__set_properties()
        self.__do_layout()

        #------------

        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)        
        self.Bind(wx.EVT_BUTTON, self.OnCredits, self.credits)
        self.Bind(wx.EVT_BUTTON, self.OnLicense, self.license)
        self.Bind(wx.EVT_BUTTON, self.OnClose, id=wx.ID_CLOSE)

    #-----------------------------------------------------------------------
        
    def __set_properties(self):
        """
        ...
        """
        
        self.SetTitle(_("About"))
        self.license.SetDefault()


    def __do_layout(self):
        """
        ...
        """
        
        sizer_7 = wx.BoxSizer(wx.VERTICAL)
        sizer_9 = wx.BoxSizer(wx.HORIZONTAL)

        #------------
        
        sizer_7.Add(self.logo, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_7.Add(self.title, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 4)
        sizer_7.Add(self.description, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 4)
        sizer_7.Add(self.website, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 4)
        sizer_9.Add(self.credits, 0, wx.ALL|wx.EXPAND, 4)
        sizer_9.Add(self.license, 0, wx.ALL|wx.EXPAND, 3)
        sizer_9.Add(self.close, 0, wx.ALL|wx.EXPAND, 4)
        sizer_7.Add(sizer_9, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL, 10)

        #------------
        
        self.SetSizer(sizer_7)
        sizer_7.Fit(self)
        self.Layout()


    def OnCredits(self, event):
        """
        ...
        """
        
        print("Event handler `OnCredits' not implemented !")
        event.Skip()


    def OnLicense(self, event):
        """
        ...
        """
        
        print("Event handler `OnLicense' not implemented !")
        event.Skip()


    def OnClose(self, event):
        """
        ...
        """
        
        print("Event handler `OnClose' not implemented !")
        event.Skip()


    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        
#---------------------------------------------------------------------------

class WxgCreditsDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)

        self.notebook = wx.Notebook(self, -1, style=0)

        #------------
        
        self.notebook_pane_6 = wx.Panel(self.notebook, -1)
        self.notebook_1_pane_5 = wx.Panel(self.notebook, -1)
        self.notebook_1_pane_4 = wx.Panel(self.notebook, -1)
        self.notebook_1_pane_3 = wx.Panel(self.notebook, -1)
        self.notebook_1_pane_2 = wx.Panel(self.notebook, -1)
        self.notebook_1_pane_1 = wx.Panel(self.notebook, -1)

        #------------
        
        self.credits_code = wx.TextCtrl(self.notebook_1_pane_1, -1, "",
                                        style=wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL)
        self.credits_documentation = wx.TextCtrl(self.notebook_1_pane_2, -1, "",
                                                 style=wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL)
        self.credits_translation = wx.TextCtrl(self.notebook_1_pane_3, -1, "",
                                               style=wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL)
        self.credits_graphics = wx.TextCtrl(self.notebook_1_pane_4, -1, "",
                                            style=wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL)
        self.credits_libraries = wx.TextCtrl(self.notebook_1_pane_5, -1, "",
                                             style=wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL)
        self.credits_sponsors = wx.TextCtrl(self.notebook_pane_6, -1, "",
                                            style=wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL)

        self.close = wx.Button(self, wx.ID_CLOSE, _("&Close"))

        #------------

        # Simplified init method.        
        self.__set_properties()
        self.__do_layout()

        #------------

        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)        
        self.Bind(wx.EVT_BUTTON, self.OnClose, id=wx.ID_CLOSE)

    #-----------------------------------------------------------------------
        
    def __set_properties(self):
        """
        ...
        """
        
        self.SetTitle(_("Credits"))


    def __do_layout(self):
        """
        ...
        """
        
        sizer_100 = wx.BoxSizer(wx.VERTICAL)
        sizer_1 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11_copy_3 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11_copy_2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11_copy_1 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11 = wx.BoxSizer(wx.HORIZONTAL)

        #------------
        
        sizer_11.Add(self.credits_code, 1, wx.EXPAND, 0)
        self.notebook_1_pane_1.SetSizer(sizer_11)

        sizer_11_copy.Add(self.credits_documentation, 1, wx.EXPAND, 0)
        self.notebook_1_pane_2.SetSizer(sizer_11_copy)

        sizer_11_copy_1.Add(self.credits_translation, 1, wx.EXPAND, 0)
        self.notebook_1_pane_3.SetSizer(sizer_11_copy_1)

        sizer_11_copy_2.Add(self.credits_graphics, 1, wx.EXPAND, 0)
        self.notebook_1_pane_4.SetSizer(sizer_11_copy_2)

        sizer_11_copy_3.Add(self.credits_libraries, 1, wx.EXPAND, 0)
        self.notebook_1_pane_5.SetSizer(sizer_11_copy_3)

        sizer_1.Add(self.credits_sponsors, 1, wx.EXPAND, 0)
        self.notebook_pane_6.SetSizer(sizer_1)

        #------------
        
        self.notebook.AddPage(self.notebook_1_pane_1, _("Code"))
        self.notebook.AddPage(self.notebook_1_pane_2, _("Documentation"))
        self.notebook.AddPage(self.notebook_1_pane_3, _("Translation"))
        self.notebook.AddPage(self.notebook_1_pane_4, _("Artwork"))
        self.notebook.AddPage(self.notebook_1_pane_5, _("Libraries"))
        self.notebook.AddPage(self.notebook_pane_6, _("Sponsors"))

        #------------
        
        sizer_100.Add(self.notebook, 1, wx.EXPAND, 0)
        sizer_100.Add(self.close, 0, wx.ALL|wx.ALIGN_RIGHT, 4)

        #------------
        
        self.SetSizer(sizer_100)
        sizer_100.Fit(self)
        self.Layout()


    def OnClose(self, event):
        """
        ...
        """
        
        print("Event handler `OnClose' not implemented !")
        event.Skip()


    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        
#---------------------------------------------------------------------------

class MyCreditsDialog(WxgCreditsDialog):
    """
    Credit dialog.
    """
    def __init__(self,parent,credits):
        """Shows a dialog with the credits of a project.
        :param parent: parent control of dialog (mostly app frame)
        :type parent: wx.Window
        :param credits: people by category
        :type credits: dictionary
        """
        super(MyCreditsDialog, self).__init__(parent, -1)

        #------------
        
        for attr, all in credits.items():
            ctrl = getattr(self, 'credits_%s' %attr)
            ctrl.SetValue('\n'.join([' - '.join(x.values()) for x in all]))

        #------------

        w, h = parent.GetSize()
        self.SetSize((int(2*w), int(h/1.5)))

        #------------
        
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)
        
    #-----------------------------------------------------------------------
        
    def OnClose(self,event):
        """
        ...
        """
        
        self.EndModal(wx.ID_CLOSE)


    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()
        
#---------------------------------------------------------------------------
        
class MyDialog(WxgAboutDialog):
    def __init__(self, parent, title, logo, description,
                 website, credits, license):
        super(MyDialog,self).__init__(parent, -1)

        #------------

        self.SetIcon(wx.Icon("wxwin.ico"))
        
        self.SetBackgroundColour(self.GetBackgroundColour())

        #------------
        
        # Title.
        self.title.SetLabel(title)
        title_font = self.title.GetFont()
        title_font.SetPointSize(title_font.GetPointSize()*3)
        self.title.SetFont(title_font)
        
        # Logo.
        self.logo.SetBitmap(logo)
        
        # Description.
        self.description.SetLabel(description.replace("&", "&&"))
        
        # Website.
        self.website.SetLabel(website)
        self.website.SetURL(website)
        
        # Save other parameters.
        self.credits = credits
        self.license = license
        
        # Layout.
        self.GetSizer().Fit(self)
        self.Layout()

        #------------
        
        self.Bind(wx.EVT_CLOSE, self.OnClose)
        
    #-----------------------------------------------------------------------
        
    def OnCredits(self,event):
        """
        ...
        """

        dlg = MyCreditsDialog(self, self.credits)
        dlg.ShowModal()
        dlg.Destroy()


    def OnLicense(self,event):
        """
        ...
        """
        
        dlg = wx.lib.dialogs.ScrolledMessageDialog(self,
                                                   self.license,
                                                   _("License"))
        dlg.ShowModal()


    def OnClose(self,event):
        """
        ...
        """
        
        self.Destroy()

#---------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------

        logo = wx.ArtProvider.GetBitmap(wx.ART_INFORMATION, wx.ART_OTHER, (128, 128))

        credits = create_credits('code', 'documentation', 'translation',
                                 'libraries', 'graphics')

        aboutDialog = MyDialog(None,
                               'My app.', logo,
                               'Description', 'Website',
                               credits, 'License (latest GPL)')
        self.SetTopWindow(aboutDialog)
        aboutDialog.Show(True)

        return True
 
#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
