# sample_one.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx
import random

# class MyDialog
# class MyApp

#---------------------------------------------------------------------------

class MyDialog(wx.Dialog):
    def __init__(self, parent, id, title):
        wx.Dialog.__init__(self, parent, id, title, size=(260, 300))

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico', wx.BITMAP_TYPE_ICO))        

        #------------
        
        panel = wx.Panel(self, -1, (75, 20), (100, 127),  style=wx.SUNKEN_BORDER)

        self.picture = wx.StaticBitmap(panel)
        panel.SetBackgroundColour(wx.WHITE)

        self.images = ['tolstoy.jpg', 'feuchtwanger.jpg', 'balzac.jpg',
                       'pasternak.jpg', 'galsworthy.jpg', 'wolfe.jpg', 'zweig.jpg']

        authors = ['Leo Tolstoy', 'Lion Feuchtwanger', 'Honore de Balzac',
                   'Boris Pasternak', 'John Galsworthy', 'Tom Wolfe', 'Stefan Zweig' ]

        wx.ComboBox(self, -1, pos=(50, 170), size=(150, -1), choices=authors, style=wx.CB_READONLY)

        wx.Button(self, 1, '&Close', (80, 220))

        #------------

        self.Bind(wx.EVT_BUTTON, self.OnClose, id=1)
        self.Bind(wx.EVT_COMBOBOX, self.OnSelect)

        #------------
        
        self.Centre()

    #-----------------------------------------------------------------------
        
    def OnClose(self, event):
        self.Close()


    def OnSelect(self, event):
        item = event.GetSelection()
        self.picture.SetFocus()
        self.picture.SetBitmap(wx.Bitmap('bitmaps/' + self.images[item]))

#---------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):
        dlg = MyDialog(None, -1, 'wx.ComboBox')
        dlg.ShowModal()
        dlg.Destroy()
        
        return True

#---------------------------------------------------------------------------
    
app = MyApp(0)
app.MainLoop()
