# eye_dropper_toy.py

import wx

#---------------------------------------------------------------------------

class EyeDropperFrame(wx.Frame):
    """
    Simple eyedropper toy.
    """
    def __init__(self, parent, title=""):
        wx.Frame.__init__(self, parent, title=title)

        self.SetIcon(wx.Icon("wxwin.ico"))
        
        #------------
        
        # Attributes
        self.panel = EyeDroppwerPanel(self)

        #------------
        
        # Layout
        self.__DoLayout()

    #-----------------------------------------------------------------------
        
    def __DoLayout(self):
        """
        ...
        """
        
        sizer = wx.BoxSizer()

        sizer.Add(self.panel, 1, wx.EXPAND)
        self.SetSizer(sizer)
        self.SetInitialSize((300, 300))

#---------------------------------------------------------------------------
        
class EyeDroppwerPanel(wx.Panel):
    def __init__(self, parent):
        wx.Panel.__init__(self, parent)

        # Attributes.
        self.palette = PreviewPalette(self, size=(100, 100))

        #------------
        
        # Layout.
        self.__DoLayout()

    #-----------------------------------------------------------------------
        
    def __DoLayout(self):
        """
        ...
        """
        
        hsizer = wx.BoxSizer(wx.HORIZONTAL)
        vsizer = wx.BoxSizer(wx.VERTICAL)

        vsizer.AddStretchSpacer()
        vsizer.Add(self.palette, 0, wx.ALL | wx.EXPAND, 30)
        vsizer.AddStretchSpacer()
        hsizer.AddStretchSpacer()
        hsizer.Add(vsizer, 0, wx.EXPAND)
        hsizer.AddStretchSpacer()

        self.SetSizer(hsizer)

#---------------------------------------------------------------------------
        
class PreviewPalette(wx.Panel):
    """
    Panel to display the color sampleing from the eyedropper.
    """
    def __init__(self, parent, id=wx.ID_ANY,
                 pos=wx.DefaultPosition, size=wx.DefaultSize):
        wx.Panel.__init__(self, parent, id, pos, size)

        # Attributes.
        self.color = wx.BLACK
        self.brush = wx.Brush(self.color)
        self.timer = wx.Timer(self)

        #------------
        
        # Event Handlers.
        self.Bind(wx.EVT_PAINT, self.OnPaint)
        self.Bind(wx.EVT_TIMER, self.OnTimer)
        self.timer.Start(250)

    #-----------------------------------------------------------------------
        
    def __del__(self):
        """
        ...
        """
        
        if self.timer.IsRunning():
            self.timer.Stop()


    def OnPaint(self, evt):
        """
        ...
        """
        
        dc = wx.PaintDC(self)
        dc.SetBrush(self.brush)
        rect = self.GetClientRect()

        # Draw the preview square.
        sq_x = (rect.width / 2) - 25
        sq_y = (rect.height / 2) - 25
        dc.DrawRectangle(int(sq_x), int(sq_y), int(50), int(50))

        hexcode = self.color.GetAsString(wx.C2S_HTML_SYNTAX)
        tsize = self.GetTextExtent(hexcode)
        lbl_rect = wx.Rect(int(sq_x - 20), int(sq_y + 55), int(90), int(20))
        print(lbl_rect)
        dc.SetPen(wx.BLACK_PEN)
        dc.SetFont(self.GetFont())
        dc.DrawLabel(hexcode, lbl_rect, wx.ALIGN_CENTER)


    def OnTimer(self, evt):
        """
        ...
        """
        
        pos = wx.GetMousePosition()
        print("position :", pos)

        dc = wx.ScreenDC()
        print("ScreenDC :", dc)

        color = dc.GetPixel(pos[0], pos[1])
        if color != self.color:
            self.color = color
            self.brush.SetColour(self.color)
            self.Refresh()

#---------------------------------------------------------------------------
            
if __name__ == '__main__':
    app = wx.App(False)
    frame = EyeDropperFrame(None, title="Eyedropper toy")
    frame.Show()
    app.MainLoop()
