# sample_two.py

"""

Purpose  : Create a customized calculator
Author   : Jan Bodnar (zetcode.com)
         : Modified By Ecco - May 2021
Thank to : Daniel Ramos (custom_button)
Link     : https://zetcode.com/wxpython/layout/

"""

import os
import sys
import wx
from   custom_button import CustomButton as CustomBtn

# class MyCalculator
# class MyFrame

#-------------------------------------------------------------------------------

class MyCalculator(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent,
                          -1, title,
                          style=wx.DEFAULT_FRAME_STYLE)

        #------------
       
        if wx.Platform == "__WXMSW__":
            self.SetDoubleBuffered(True)
        
        #------------
            
        self.parent = parent
        self.formula = False
        
        #------------

        # Return icons folder.
        self.icon_dir = wx.GetApp().GetIconDir()
        # Return bitmaps folder. 
        self.bitmap_dir = wx.GetApp().GetBitmapDir()
        
        #------------
        
        # Simplified init method
        self.SetProperties()
        self.CreateCtrls()
        self.MakeMenuBar()
        self.BindEvents()
        self.DoLayout()        

        #------------

        self.CenterOnParent()
        self.GetParent().Enable(False)
        self.Show(True)

        self.__eventLoop = wx.GUIEventLoop()
        self.__eventLoop.Run()
        
    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the dialog properties (title, icon...).
        """

        # Set frame icon. 
        frameicon = wx.Icon(os.path.join(self.icon_dir,
                                         "wxwin.ico"),
                            type=wx.BITMAP_TYPE_ICO)

        self.SetIcon(frameicon)
        self.SetSize((420, 300))
        self.SetMinSize((430, 310))
        

    def MakeMenuBar(self):
        """
        Make menu data.
        """

        menubar = wx.MenuBar()

        #------------
        
        menuFile = wx.Menu()

        #------------

        # Add a bitmap to "exitItem" menu.
        bmp = wx.Bitmap(os.path.join(self.bitmap_dir,
                                     "item_quit.png"),
                        type=wx.BITMAP_TYPE_PNG)     

        exitItem = wx.MenuItem(parentMenu=menuFile, 
                               id=22,
                               text="&Quit\tCtrl+Q",
                               helpString="Exit Calculator.",
                               kind=wx.ITEM_NORMAL,
                               subMenu=None)
        exitItem.SetBitmap(bmp)
        menuFile.Append(exitItem)
        
        #------------
        
        menubar.Append(menuFile, '&File')

        #------------
        
        self.SetMenuBar(menubar)

        
    def CreateCtrls(self):
        """
        ...    
        """
        
        self.panel = wx.Panel(self, -1)

        #------------
        
        self.display = wx.TextCtrl(self.panel, -1,
                                   "",
                                   style=wx.TE_RIGHT|
                                         wx.TE_PROCESS_ENTER)
        self.display.SetBackgroundColour("#fded68") 
        self.display.SetForegroundColour("#0326f9") 
        self.display.SetFocus()
        
        #------------
        
        self.btn1 = CustomBtn(self.panel, 20, 'Clr')
        self.btn1.set_font(wx.Font(10, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.btn1.set_foreground_color('#008B00')
        self.btn1.set_text_shadow((1, 1, '#ffffff'))
        self.btn1.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn1.set_border((1, '#3076A9', 3))
        self.btn1.set_padding((5, 10, 5, 10))
        self.btn1.center_content(True)
        
        self.btn2 = CustomBtn(self.panel, 21, 'Bck')
        self.btn2.set_font(wx.Font(10, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.btn2.set_foreground_color('#0e4e0e')
        self.btn2.set_text_shadow((1, 1, '#ffffff'))
        self.btn2.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn2.set_border((1, '#3076A9', 3))
        self.btn2.set_padding((5, 10, 5, 10))
        self.btn2.center_content(True)

        self.txt3 = wx.StaticText(self.panel, -1, '')

        self.btn4 = CustomBtn(self.panel, 22, 'Close')
        self.btn4.set_font(wx.Font(10, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.btn4.set_foreground_color('red')
        self.btn4.set_text_shadow((1, 1, '#ffffff'))
        self.btn4.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn4.set_border((1, '#3076A9', 3))
        self.btn4.set_padding((5, 10, 5, 10))
        self.btn4.center_content(True)

        self.btn5 = CustomBtn(self.panel, 1, '7')
        self.btn5.set_foreground_color('#000000')
        self.btn5.set_text_shadow((1, 1, '#ffffff'))
        self.btn5.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn5.set_border((1, '#3076A9', 3))
        self.btn5.set_padding((5, 10, 5, 10))
        self.btn5.center_content(True)

        self.btn6 = CustomBtn(self.panel, 2, '8')
        self.btn6.set_foreground_color('#000000')
        self.btn6.set_text_shadow((1, 1, '#ffffff'))
        self.btn6.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn6.set_border((1, '#3076A9', 3))
        self.btn6.set_padding((5, 10, 5, 10))
        self.btn6.center_content(True)

        self.btn7 = CustomBtn(self.panel, 3, '9')
        self.btn7.set_foreground_color('#000000')
        self.btn7.set_text_shadow((1, 1, '#ffffff'))
        self.btn7.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn7.set_border((1, '#3076A9', 3))
        self.btn7.set_padding((5, 10, 5, 10))
        self.btn7.center_content(True)
        
        self.btn8 = CustomBtn(self.panel, 4, '/')
        self.btn8.set_foreground_color('#000000')
        self.btn8.set_text_shadow((1, 1, '#ffffff'))
        self.btn8.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn8.set_border((1, '#3076A9', 3))
        self.btn8.set_padding((5, 10, 5, 10))
        self.btn8.center_content(True)
        
        self.btn9 = CustomBtn(self.panel, 5, '4')
        self.btn9.set_foreground_color('#000000')
        self.btn9.set_text_shadow((1, 1, '#ffffff'))
        self.btn9.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn9.set_border((1, '#3076A9', 3))
        self.btn9.set_padding((5, 10, 5, 10))
        self.btn9.center_content(True)
        
        self.btn10 = CustomBtn(self.panel, 6, '5')
        self.btn10.set_foreground_color('#000000')
        self.btn10.set_text_shadow((1, 1, '#ffffff'))
        self.btn10.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn10.set_border((1, '#3076A9', 3))
        self.btn10.set_padding((5, 10, 5, 10))
        self.btn10.center_content(True)
        
        self.btn11 = CustomBtn(self.panel, 7, '6')
        self.btn11.set_foreground_color('#000000')
        self.btn11.set_text_shadow((1, 1, '#ffffff'))
        self.btn11.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn11.set_border((1, '#3076A9', 3))
        self.btn11.set_padding((5, 10, 5, 10))
        self.btn11.center_content(True)
        
        self.btn12 = CustomBtn(self.panel, 8, '*')
        self.btn12.set_foreground_color('#000000')
        self.btn12.set_text_shadow((1, 1, '#ffffff'))
        self.btn12.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn12.set_border((1, '#3076A9', 3))
        self.btn12.set_padding((5, 10, 5, 10))
        self.btn12.center_content(True)
        
        self.btn13 = CustomBtn(self.panel, 9, '1')
        self.btn13.set_foreground_color('#000000')
        self.btn13.set_text_shadow((1, 1, '#ffffff'))
        self.btn13.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn13.set_border((1, '#3076A9', 3))
        self.btn13.set_padding((5, 10, 5, 10))
        self.btn13.center_content(True)
        
        self.btn14 = CustomBtn(self.panel, 10, '2')
        self.btn14.set_foreground_color('#000000')
        self.btn14.set_text_shadow((1, 1, '#ffffff'))
        self.btn14.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn14.set_border((1, '#3076A9', 3))
        self.btn14.set_padding((5, 10, 5, 10))
        self.btn14.center_content(True)
        
        self.btn15 = CustomBtn(self.panel, 11, '3')
        self.btn15.set_foreground_color('#000000')
        self.btn15.set_text_shadow((1, 1, '#ffffff'))
        self.btn15.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn15.set_border((1, '#3076A9', 3))
        self.btn15.set_padding((5, 10, 5, 10))
        self.btn15.center_content(True)
        
        self.btn16 = CustomBtn(self.panel, 12, '-')
        self.btn16.set_foreground_color('#000000')
        self.btn16.set_text_shadow((1, 1, '#ffffff'))
        self.btn16.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn16.set_border((1, '#3076A9', 3))
        self.btn16.set_padding((5, 10, 5, 10))
        self.btn16.center_content(True)
        
        self.btn17 = CustomBtn(self.panel, 13, '0')
        self.btn17.set_foreground_color('#000000')
        self.btn17.set_text_shadow((1, 1, '#ffffff'))
        self.btn17.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn17.set_border((1, '#3076A9', 3))
        self.btn17.set_padding((5, 10, 5, 10))
        self.btn17.center_content(True)

        self.btn18 = CustomBtn(self.panel, 14, '.')
        self.btn18.set_foreground_color('#000000')
        self.btn18.set_text_shadow((1, 1, '#ffffff'))
        self.btn18.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn18.set_border((1, '#3076A9', 3))
        self.btn18.set_padding((5, 10, 5, 10))
        self.btn18.center_content(True)
        
        self.btn19 = CustomBtn(self.panel, 15, '=')
        self.btn19.set_foreground_color('#000000')
        self.btn19.set_text_shadow((1, 1, '#ffffff'))
        self.btn19.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn19.set_border((1, '#3076A9', 3))
        self.btn19.set_padding((5, 10, 5, 10))
        self.btn19.center_content(True)
        
        self.btn20 = CustomBtn(self.panel, 16, '+')
        self.btn20.set_foreground_color('#000000')
        self.btn20.set_text_shadow((1, 1, '#ffffff'))
        self.btn20.set_bg_gradient(('#CEE3F2', '#438FC9'), ('#ABCEE9', '#3279AD'),
                                  ('#8EBEE1', '#2C6A98'), ('#6DABD8', '#225275'))
        self.btn20.set_border((1, '#3076A9', 3))
        self.btn20.set_padding((5, 10, 5, 10))
        self.btn20.center_content(True)

        self.panel.SetBackgroundColour("#cce8f2")        
        

    def BindEvents(self):
        """
        ...  
        """

        self.display.Bind(wx.EVT_TEXT_ENTER, self.OnTextEnter)
        
        self.Bind(wx.EVT_BUTTON, self.OnClear, id=20)
        self.Bind(wx.EVT_BUTTON, self.OnBackspace, id=21)
        self.Bind(wx.EVT_BUTTON, self.OnClose, id=22)
        self.Bind(wx.EVT_BUTTON, self.OnSeven, id=1)
        self.Bind(wx.EVT_BUTTON, self.OnEight, id=2)
        self.Bind(wx.EVT_BUTTON, self.OnNine, id=3)
        self.Bind(wx.EVT_BUTTON, self.OnDivide, id=4)
        self.Bind(wx.EVT_BUTTON, self.OnFour, id=5)
        self.Bind(wx.EVT_BUTTON, self.OnFive, id=6)
        self.Bind(wx.EVT_BUTTON, self.OnSix, id=7)
        self.Bind(wx.EVT_BUTTON, self.OnMultiply, id=8)
        self.Bind(wx.EVT_BUTTON, self.OnOne, id=9)
        self.Bind(wx.EVT_BUTTON, self.OnTwo, id=10)
        self.Bind(wx.EVT_BUTTON, self.OnThree, id=11)
        self.Bind(wx.EVT_BUTTON, self.OnMinus, id=12)
        self.Bind(wx.EVT_BUTTON, self.OnZero, id=13)
        self.Bind(wx.EVT_BUTTON, self.OnDot, id=14)
        self.Bind(wx.EVT_BUTTON, self.OnEqual, id=15)
        self.Bind(wx.EVT_BUTTON, self.OnPlus, id=16)

        self.Bind(wx.EVT_MENU, self.OnClose, id=22)

        self.Bind(wx.EVT_CHAR_HOOK, self.OnKeyUp)
        
        # (Allows frame's title-bar close to work)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow) 
        

    def DoLayout(self):
        """
        ...    
        """

        # Sizers         
        # MainSizer is the top-level one that manages everything   
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        gridSizer = wx.GridSizer(5, 4, 5, 5)

        #------------

        # Assign widgets to sizers 
        mainSizer.Add(self.display, 0, wx.EXPAND | wx.ALL, 5)

        gridSizer.AddMany([(self.btn1, 1, wx.EXPAND),
                           (self.btn2, 1, wx.EXPAND),
                           (self.txt3, 1, wx.EXPAND),
                           (self.btn4, 1, wx.EXPAND),
                           (self.btn5, 1, wx.EXPAND),
                           (self.btn6, 1, wx.EXPAND),
                           (self.btn7, 1, wx.EXPAND),
                           (self.btn8, 1, wx.EXPAND),
                           (self.btn9, 1, wx.EXPAND),
                           (self.btn10, 1, wx.EXPAND),
                           (self.btn11, 1, wx.EXPAND),
                           (self.btn12, 1, wx.EXPAND),
                           (self.btn13, 1, wx.EXPAND),
                           (self.btn14, 1, wx.EXPAND),
                           (self.btn15, 1, wx.EXPAND),
                           (self.btn16, 1, wx.EXPAND),
                           (self.btn17, 1, wx.EXPAND),
                           (self.btn18, 1, wx.EXPAND),
                           (self.btn19, 1, wx.EXPAND),
                           (self.btn20, 1, wx.EXPAND)])

        # Assign to mainSizer the other sizers
        mainSizer.Add(gridSizer, 1, wx.EXPAND | wx.ALL, 5)

        #------------
        
        self.panel.SetSizer(mainSizer)
        mainSizer.Fit(self)
        

    def OnTextEnter(self, event):
        """
        ...    
        """

        self.OnEqual(event)
        

    def OnClear(self, event):
        """
        ...    
        """
                
        self.display.Clear()
        self.display.SetFocus()
        

    def OnBackspace(self, event):
        """
        ...    
        """
        
        formula = self.display.GetValue()
        self.display.Clear()
        self.display.SetValue(formula[:-1])
        self.display.SetFocus()
        

    def OnDivide(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('*')
        self.display.SetFocus()
        

    def OnMultiply(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('*')
        self.display.SetFocus()
        

    def OnMinus(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('-')
        self.display.SetFocus()
        

    def OnPlus(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('+')
        self.display.SetFocus()
        

    def OnDot(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('.')
        self.display.SetFocus()
        

    def OnEqual(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        formula = self.display.GetValue()
        self.formula = False
        try:
            self.display.Clear()
            output = eval(formula)
            self.display.AppendText(str(output))
        except SyntaxError:  # StandardError
            self.display.AppendText("Error")
            self.display.SetFocus()
            
#        self.display.Clear()
#        output = eval(formula)
#        self.display.AppendText(str(output))
#        self.display.SetFocus()


    def OnZero(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('0')
        self.display.SetFocus()
        

    def OnOne(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('1')
        self.display.SetFocus()
        

    def OnTwo(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('2')
        self.display.SetFocus()
        

    def OnThree(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('3')
        self.display.SetFocus()
        

    def OnFour(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('4')
        self.display.SetFocus()
        

    def OnFive(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('5')
        self.display.SetFocus()
        

    def OnSix(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('6')
        self.display.SetFocus()
        

    def OnSeven(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('7')
        self.display.SetFocus()
        

    def OnEight(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('8')
        self.display.SetFocus()
        

    def OnNine(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('9')
        self.display.SetFocus()
        

    def OnKeyUp(self, event):
        """
        Handles the wx.EVT_CHAR_HOOK event for the dialog.
        """

        if event.GetKeyCode() == wx.WXK_ESCAPE:
            # Close the dialog, no action
            self.OnClose(event)

        event.Skip()

        
    def OnClose(self, event):
        """
        ...    
        """
        
        self.Close()

        
    def OnCloseWindow(self, event):
        """
        ...    
        """
        
        self.GetParent().Enable(True)
        self.__eventLoop.Exit()
        self.Destroy()
        
#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen()

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle("Sample one")
        self.SetIcon(wx.Icon('icon/wxwin.ico'))


    def CreateCtrls(self):
        """
        ...
        """

        self.panel = wx.Panel(self, -1)

        self.btnDlg = wx.Button(self.panel,
                                -1,
                                "&Show customized calculator frame")

        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")


    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind the close event to an event handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

        # Bind the buttons event to an event handler.
        self.Bind(wx.EVT_BUTTON, self.OnScreenshot, self.btnDlg)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)


    def DoLayout(self):
        """
        ...
        """

        # mainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)
        # wx.BoxSizer(sizer, proportion, flag, border)
        mainSizer.Add(self.btnDlg, 1, wx.EXPAND | wx.ALL, 10)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)


    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)


    def OnScreenshot(self, event):
        """
        ...
        """

        frmCal = MyCalculator(self, -1, 'Calculator')
        

    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()

#-------------------------------------------------------------------------------

class MyApp(wx.App):
    def OnInit(self):

        #------------
        
        self.installDir = os.path.split(os.path.abspath(sys.argv[0]))[0]

        #------------
        
        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

    #-----------------------------------------------------------------------
    
    def GetInstallDir(self):
        """
        Return the installation directory for my application.
        """

        return self.installDir


    def GetIconDir(self):
        """
        Return the icons directory for my application.
        """

        icon_dir = os.path.join(self.installDir, "icon")
        return icon_dir


    def GetBitmapDir(self):
        """
        Return the bitmaps directory for my application.
        """

        bitmap_dir = os.path.join(self.installDir, "bitmap")
        return bitmap_dir
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
