# sample_three.py

"""

https://vcansimplify.wordpress.com/category/python-2/wxpython-python/

"""

import wx 
from math import *  # To enable writing sin(13) instead of math.sin(13)

# class MyFrame
# class MyCalcFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    Frame and widgets to handle input and output of mortgage calc.
    """
    def __init__(self, parent):
        wx.Frame.__init__(self, parent, -1, "Math.sin calculator")

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        # Add panel, labels, text and sizer widgets.
        panel = wx.Panel(self, -1)

        self.text = wx.TextCtrl(panel, -1,
                                size=(290, 100),
                                style=wx.TE_MULTILINE)
        
        solveBtn = wx.Button(panel, -1, "&Solve")
        solveBtn.Bind(wx.EVT_BUTTON, self.solveFunc)

        clearBtn = wx.Button(panel, -1, "&Clear")
        clearBtn.Bind(wx.EVT_BUTTON, self.clearFunc)
            
        # Use boxsizer to add border around sizer.
        border = wx.BoxSizer(wx.VERTICAL)
        border.Add(self.text, 1, wx.EXPAND | wx.ALL, 5)
        border.Add(solveBtn, 1, wx.EXPAND | wx.ALL, 5)
        border.Add(clearBtn, 1, wx.EXPAND | wx.ALL, 5)
        
        panel.SetSizerAndFit(border)
        self.Fit()

    #-----------------------------------------------------------------------
        
    def solveFunc(self, event):
        """
        What to when 'Solve' is clicked
        wx calls this function with and 'event' object.
        """

        try:
            # Evaluate the string in 'text' and put the answer back.
            ans = eval(self.text.GetValue())
            self.text.SetValue(str(ans))
        except Exception:
            print('error')


    def clearFunc(self,event):
        """
        Put a blank string in text when 'Clear' is clicked.
        """
        
        self.text.SetValue(str(''))

#---------------------------------------------------------------------------
        
class MyCalcFrame(MyFrame):
    """
    Constructor.
    Inherit from the MainFrame created in wxFowmBuilder and create CalcFrame.
    """
    def __init__(self, parent):
        # Initialize parent class.
        MyFrame.__init__(self, parent)
        
#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):

        #------------

        # Create an object of MyCalcFrame.
        frame = MyCalcFrame(None)
        self.SetTopWindow(frame)
        # Show the frame.
        frame.Show(True)

        return True
    
#---------------------------------------------------------------------------

def main():
    # Mandatory in wx, create an app, False stands for not 
    # deteriction stdin/stdout refer manual for details.
    app = MyApp(False)
    # Start the applications.
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
    
