# sample_ten.py

"""

A few experiments with wxPython's
Test wx.Slider (move the slider to calculate F and C values)
wx.Slider(parent, id, value, minValue, maxValue, pos, size, style)
style -->
wx.SL_VERTICAL  displays the slider vertically
wx.SL_HORIZONTAL  displays the slider horizontally
wx.SL_AUTOTICKS  displays tick marks
wx.SL_LABELS  displays minimum, maximum and value labels
Author : Dietrich - 17NOV2008
https://www.daniweb.com/programming/software-development/threads/128350/starting-wxpython-gui-code/

"""

import wx

# class MyFrame

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, mytitle, mysize):
        wx.Frame.__init__(self, parent, wx.ID_ANY, mytitle, size=mysize)
        
        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))
        self.SetBackgroundColour('white')

        #------------

        self.panel = wx.Panel(self, wx.ID_ANY)
        self.panel.SetDoubleBuffered(True)  # No flickering
        
        # All values are integer values only
        self.slider = wx.Slider(self.panel, wx.ID_ANY,
                                value=-40,  # The initial value of slider position
                                minValue=-100,
                                maxValue=400,
                                pos=(10, 10),
                                size=(620, 40),
                                style=wx.SL_HORIZONTAL|wx.SL_LABELS)
        # Respond to changes in slider position
        self.Bind(wx.EVT_SLIDER, self.sliderUpdate)
       
        self.label = wx.StaticText(self.panel, wx.ID_ANY, label="", pos=(70, 60))
        self.label.SetForegroundColour("blue")
        # self.label.SetBackgroundColour("yellow")

        #------------
        
        # Use initial setting
        self.sliderUpdate()

    #-----------------------------------------------------------------------
        
    def sliderUpdate(self, event=None):
        """
        Slider position is an integer, as the slider is moved
        Fahrenheit and Celcius are calculated in real time
        """
        
        pos = self.slider.GetValue()
        
        f = str(round(pos * 9.0/5 + 32, 2))
        c = str(round((pos - 32)*5/9.0, 2))
        v = str(pos)
        
        s1 = v + " degree Fahrenheit is " + c + " degree Celcius \n"
        s2 = v + " degree Celcius is " + f + " degree Fahrenheit"
        
        self.label.SetLabel(s1 + s2)

#---------------------------------------------------------------------------
        
app = wx.App(0)
# Create a MyFrame instance and show the frame
mytitle = 'Calculate Fahrenheit and Celcius'
width = 660
height = 150
MyFrame(None, mytitle, (width, height)).Show()
app.MainLoop()
