# sample_six.py

"""

Create a calulator button layout with wx.GridSizer().
Then add a few things to form a tiny wxPython calculator.
https://stackoverflow.com/questions/16435607/range-object-does-not-support-item-assignment-trying-to-use-old-python-code

"""

import wx

# class MyFrame

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    Make a frame, inherits wx.Frame.
    """
    def __init__(self):
        # Create a frame/window, no parent
        wx.Frame.__init__(self, None, wx.ID_ANY, 'Tiny calculator',
                          pos=(300, 150), size=(300, 200))

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))
        self.SetBackgroundColour('purple')

        #------------
        
        # Main sizer
        vsizer = wx.BoxSizer(wx.VERTICAL)

        self.edit = wx.TextCtrl(self, -1, value="", size=(165, 20))

        # Follows layout of calculator keys
        self.btn_list = [
        '7', '8', '9', '/', 'c',
        '4', '5', '6', '*', 'bs',
        '1', '2', '3', '-', '**',
        '0', '.', '=', '+', 'neg'
        ]

        #------------
        
        # wx.GridSizer(rows, cols, vgap, hgap)
        gsizer = wx.GridSizer(4, 5, 2, 2)

        self.btn = list(range(len(self.btn_list)))
        for ix, b_label in enumerate(self.btn_list):
            # Set up a consecutive unique id for each button
            id = 1000 + ix
            self.btn[ix] = wx.Button(self, id, label=b_label, size=(20, 20))
            # The gridsizer fills left to right one row at a time
            gsizer.Add(self.btn[ix], 0, wx.ALL|wx.EXPAND, border=2)
            self.btn[ix].Bind(wx.EVT_BUTTON, self.btnClick)

        #------------
            
        # Now add the whole thing to the main sizer and set it
        vsizer.Add(self.edit, 0, wx.EXPAND)
        vsizer.Add(gsizer, 1, wx.EXPAND)
        self.SetSizer(vsizer)

    #-----------------------------------------------------------------------

    def btnClick(self, event):
        """
        ...
        """
        
        # Get the label of the button clicked
        label = self.btn_list[event.GetId() - 1000]
        e_list = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
            '+', '-', '*', '/', '**', '.']
        
        if label in e_list:
            self.edit.SetValue(self.edit.GetValue() + label)
        elif label == 'neg':
            # Negate, note eval() takes care of double negate
            self.edit.SetValue('-' + self.edit.GetValue())
        elif label == 'c':
            # Cclear
            self.edit.SetValue('')
        elif label == 'bs':
            # Backspace
            self.edit.SetValue(self.edit.GetValue()[:-1])
        elif label == '=':
            str1 = self.edit.GetValue()
            # Prevent folks from being nasty with eval()
            if not str1 or str1[0] not in '0123456789-+.':
                self.edit.SetValue('unrecognized operation')
                return
            while str1[0] == '0':
                # Avoid leading zero (octal) error with eval()
                str1 = str1[1:]
            if '/' in str1 and '.' not in str1:
                # Turn into floating point division
                str1 = str1 + '.0'
            try:
                self.edit.SetValue(str(eval(str1)))
            except ZeroDivisionError:
                self.edit.SetValue('division by zero error')
        else:
            self.edit.SetValue('unrecognized operation')

#---------------------------------------------------------------------------
            
app = wx.App(0)
# Create MyFrame instance and show the frame
MyFrame().Show()
app.MainLoop()
