# sample_seven.py

"""

Author : Sneekula
Use slider inputs to calculate cost of petrol in the USA and Europe.
https://www.daniweb.com/programming/software-development/threads/128350/starting-wxpython-gui-code/2#post1823238

"""

import wx

# class MyFrame

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, mytitle, mysize):
        wx.Frame.__init__(self, parent, wx.ID_ANY, mytitle, size=mysize)

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))        
        self.SetBackgroundColour("yellow")

        #------------
        
        # Create input widgets

        self.panel = wx.Panel(self, wx.ID_ANY)
        self.panel.SetDoubleBuffered(True)  # No flickering
        
        # Label for slider1
        label_s1 = wx.StaticText(self.panel, wx.ID_ANY, "US cents per US Gallon :")
        
        # Can only use integer values!!!
        # Initial value = 450, min value = 300, max value = 600
        self.slider1 = wx.Slider(self.panel, wx.ID_ANY, 250, 180, 600, size=(320, 40),
            style=wx.SL_HORIZONTAL|wx.SL_LABELS)
        
        # Label for slider2
        label_s2 = wx.StaticText(self.panel, wx.ID_ANY, "Euro cents per Liter :")
        
        # Initial value = 150, min value = 100, max value = 200
        self.slider2 = wx.Slider(self.panel, wx.ID_ANY, 100, 50, 250, size=(320, 40),
            style=wx.SL_HORIZONTAL|wx.SL_LABELS)
        
        # Label for slider3
        label_s3 = wx.StaticText(self.panel, wx.ID_ANY, "US cents per Euro :")
        
        # Initial value = 160, min value = 100, max value = 200
        self.slider3 = wx.Slider(self.panel, wx.ID_ANY, 120, 80, 200, size=(320, 40),
            style=wx.SL_HORIZONTAL|wx.SL_LABELS)

        # Bind all mouse slider marker drags to the same action
        self.Bind(wx.EVT_SLIDER, self.onAction)

        # Create an output widget
        self.label = wx.StaticText(self.panel, wx.ID_ANY, "")

        #------------
        
        # Use a vertical boxsizer for the widget placement
        sizer_v = wx.BoxSizer(wx.VERTICAL)
        sizer_h = wx.BoxSizer(wx.HORIZONTAL)
        sizer_v.Add(label_s1, 0, flag=wx.LEFT|wx.RIGHT|wx.EXPAND, border=10)
        sizer_v.Add(self.slider1, 0, flag=wx.ALL|wx.EXPAND, border=5)
        sizer_v.Add(label_s2, 0, flag=wx.LEFT|wx.RIGHT|wx.EXPAND, border=10)
        sizer_v.Add(self.slider2, 0, flag=wx.ALL|wx.EXPAND, border=5)
        sizer_v.Add(label_s3, 0, flag=wx.LEFT|wx.RIGHT|wx.EXPAND, border=10)
        sizer_v.Add(self.slider3, 0, flag=wx.ALL|wx.EXPAND, border=5)
        sizer_v.Add(self.label, 0, flag=wx.ALL|wx.EXPAND, border=10)
        sizer_h.Add(sizer_v, 0, flag=wx.ALL|wx.EXPAND, border=15)        

        self.panel.SetSizer(sizer_h)

        # Show opening result
        self.onAction(None)

    #-----------------------------------------------------------------------

    def onAction(self, event):
        """
        Some action code.
        """
        
        s = "The result... \n\n"
        
        # Gives integer cents values, convert to $ and Euro
        us_price = self.slider1.GetValue()/100.0
        euro_price = self.slider2.GetValue()/100.0
        euro_cost = self.slider3.GetValue()/100.0
        
        # 1 US gal = 3.785 liters
        s1 = "In the USA $%.2f/gal = $%.2f/liter = %.2f Euro/liter\n" % \
            (us_price, us_price/3.785, us_price/(3.785*euro_cost))
        s2 = "In Europe  $%.2f/gal = $%.2f/liter = %.2f Euro/liter" % \
            (euro_price*euro_cost*3.785, euro_price*euro_cost, euro_price)
        
        self.label.SetLabel(s + s1 + s2)

#---------------------------------------------------------------------------
        
app = wx.App()
# Create the MyFrame instance and then show the frame
frm = MyFrame(None, 'The petrol sliders', (380, 345))
frm.Show(True)
app.MainLoop()

