# sample_one.py

"""

Purpose : Create a customized calculator
Author  : Jan Bodnar (zetcode.com)
        : Modified By Ecco - May 2021
Link    : https://zetcode.com/wxpython/layout/

"""

import os
import wx

# class MyCalculator
# class MyFrame

#-------------------------------------------------------------------------------

class MyCalculator(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent,
                          -1, title,
                          style=wx.DEFAULT_FRAME_STYLE)

        #------------
        
        self.parent = parent
        self.formula = False
        
        #------------
        
        # Simplified init method
        self.SetProperties()
        self.CreateCtrls()
        self.MakeMenuBar()
        self.BindEvents()
        self.DoLayout()        

        #------------

        self.CenterOnParent()
        self.GetParent().Enable(False)
        self.Show(True)

        self.__eventLoop = wx.GUIEventLoop()
        self.__eventLoop.Run()
        
    #---------------------------------------------------------------------------

    def SetProperties(self):
        """
        Set the dialog properties (title, icon...).
        """

        # Set frame icon. 
        self.SetIcon(wx.Icon('icons/wxwin.ico'))
        self.SetSize((420, 300))
        self.SetMinSize((430, 310))


    def MakeMenuBar(self):
        """
        Make menu data.
        """

        menubar = wx.MenuBar()

        #------------
        
        menuFile = wx.Menu()

        #------------

        # Add a bitmap to "exitItem" menu.
        bmp = wx.Bitmap("bitmaps/item_quit.png", wx.BITMAP_TYPE_PNG)     

        exitItem = wx.MenuItem(parentMenu=menuFile,
                               id=22,
                               text="&Quit\tCtrl+Q",
                               helpString="Exit Calculator.",
                               kind=wx.ITEM_NORMAL,
                               subMenu=None)
        exitItem.SetBitmap(bmp)
        menuFile.Append(exitItem)
        
        #------------
        
        menubar.Append(menuFile, '&File')

        #------------
        
        self.SetMenuBar(menubar)

        
    def CreateCtrls(self):
        """
        ...    
        """

        # wx.Font(pointSize, family, style, weight, underline, faceName)
        font = wx.SystemSettings.GetFont(wx.SYS_DEFAULT_GUI_FONT)
        font.SetWeight(wx.BOLD)

        #------------
        
        self.panel = wx.Panel(self, -1)
        
        self.display = wx.TextCtrl(self.panel,
                                   -1, '',
                                   style=wx.TE_RIGHT)
        self.display.SetBackgroundColour("#fded68") 
        self.display.SetForegroundColour("#0326f9")
        self.display.SetFocus()
        
        #------------

        self.btn1 = wx.Button(self.panel, 20, 'Clr')
        self.btn2 = wx.Button(self.panel, 21, 'Bck')
        self.txt3 = wx.StaticText(self.panel, -1, '')
        self.btn4 = wx.Button(self.panel, 22, '&Close')
        self.btn5 = wx.Button(self.panel, 1, '7')
        self.btn6 = wx.Button(self.panel, 2, '8')
        self.btn7 = wx.Button(self.panel, 3, '9')
        self.btn8 = wx.Button(self.panel, 4, '/')
        self.btn9 = wx.Button(self.panel, 5, '4')
        self.btn10 = wx.Button(self.panel, 6, '5')
        self.btn11 = wx.Button(self.panel, 7, '6')
        self.btn12 = wx.Button(self.panel, 8, '*')
        self.btn13 = wx.Button(self.panel, 9, '1')
        self.btn14 = wx.Button(self.panel, 10, '2')
        self.btn15 = wx.Button(self.panel, 11, '3')
        self.btn16 = wx.Button(self.panel, 12, '-')
        self.btn17 = wx.Button(self.panel, 13, '0')
        self.btn18 = wx.Button(self.panel, 14, '.')
        self.btn19 = wx.Button(self.panel, 15, '=')
        self.btn20 = wx.Button(self.panel, 16, '+')

        self.btn1.SetForegroundColour("#008B00")
        self.btn2.SetForegroundColour("blue")
        self.btn4.SetForegroundColour("red")
        self.btn5.SetForegroundColour("blue")
        self.btn6.SetForegroundColour("blue")
        self.btn7.SetForegroundColour("blue")
        self.btn8.SetForegroundColour("blue")
        self.btn9.SetForegroundColour("blue")
        self.btn10.SetForegroundColour("blue")
        self.btn11.SetForegroundColour("blue")
        self.btn12.SetForegroundColour("blue")
        self.btn13.SetForegroundColour("blue")
        self.btn14.SetForegroundColour("blue")
        self.btn15.SetForegroundColour("blue")
        self.btn16.SetForegroundColour("blue")
        self.btn17.SetForegroundColour("blue")
        self.btn18.SetForegroundColour("blue")
        self.btn19.SetForegroundColour("blue")
        self.btn20.SetForegroundColour("blue")

        self.panel.SetBackgroundColour("#cce8f2")        
        
        self.btn1.SetFont(font)
        self.btn2.SetFont(font)
        self.btn4.SetFont(font)
        self.btn19.SetFont(font)
        
        self.btn19.SetDefault()
        

    def BindEvents(self):
        """
        ...  
        """
        
        self.Bind(wx.EVT_BUTTON, self.OnClear, id=20)
        self.Bind(wx.EVT_BUTTON, self.OnBackspace, id=21)
        self.Bind(wx.EVT_BUTTON, self.OnClose, id=22)
        self.Bind(wx.EVT_BUTTON, self.OnSeven, id=1)
        self.Bind(wx.EVT_BUTTON, self.OnEight, id=2)
        self.Bind(wx.EVT_BUTTON, self.OnNine, id=3)
        self.Bind(wx.EVT_BUTTON, self.OnDivide, id=4)
        self.Bind(wx.EVT_BUTTON, self.OnFour, id=5)
        self.Bind(wx.EVT_BUTTON, self.OnFive, id=6)
        self.Bind(wx.EVT_BUTTON, self.OnSix, id=7)
        self.Bind(wx.EVT_BUTTON, self.OnMultiply, id=8)
        self.Bind(wx.EVT_BUTTON, self.OnOne, id=9)
        self.Bind(wx.EVT_BUTTON, self.OnTwo, id=10)
        self.Bind(wx.EVT_BUTTON, self.OnThree, id=11)
        self.Bind(wx.EVT_BUTTON, self.OnMinus, id=12)
        self.Bind(wx.EVT_BUTTON, self.OnZero, id=13)
        self.Bind(wx.EVT_BUTTON, self.OnDot, id=14)
        self.Bind(wx.EVT_BUTTON, self.OnEqual, id=15)
        self.Bind(wx.EVT_BUTTON, self.OnPlus, id=16)

        self.Bind(wx.EVT_MENU, self.OnClose, id=22)

        self.Bind(wx.EVT_CHAR_HOOK, self.OnKeyUp)
        
        # (Allows frame's title-bar close to work)
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow) 
        

    def DoLayout(self):
        """
        ...    
        """

        # Sizers         
        # MainSizer is the top-level one that manages everything   
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        gridSizer = wx.GridSizer(5, 4, 5, 5)

        #------------

        # Assign widgets to sizers
        mainSizer.Add(self.display, 0, wx.EXPAND | wx.ALL, 5)

        gridSizer.AddMany([(self.btn1, 1, wx.EXPAND),
                           (self.btn2, 1, wx.EXPAND),
                           (self.txt3, 1, wx.EXPAND),
                           (self.btn4, 1, wx.EXPAND),
                           (self.btn5, 1, wx.EXPAND),
                           (self.btn6, 1, wx.EXPAND),
                           (self.btn7, 1, wx.EXPAND),
                           (self.btn8, 1, wx.EXPAND),
                           (self.btn9, 1, wx.EXPAND),
                           (self.btn10, 1, wx.EXPAND),
                           (self.btn11, 1, wx.EXPAND),
                           (self.btn12, 1, wx.EXPAND),
                           (self.btn13, 1, wx.EXPAND),
                           (self.btn14, 1, wx.EXPAND),
                           (self.btn15, 1, wx.EXPAND),
                           (self.btn16, 1, wx.EXPAND),
                           (self.btn17, 1, wx.EXPAND),
                           (self.btn18, 1, wx.EXPAND),
                           (self.btn19, 1, wx.EXPAND),
                           (self.btn20, 1, wx.EXPAND)])

        # Assign to mainSizer the other sizers
        mainSizer.Add(gridSizer, 1, wx.EXPAND | wx.ALL, 5)

        #------------
        
        self.panel.SetSizer(mainSizer)
        mainSizer.Fit(self)


    def OnClear(self, event):
        """
        ...    
        """
                
        self.display.Clear()
        self.display.SetFocus()
        

    def OnBackspace(self, event):
        """
        ...    
        """
        
        formula = self.display.GetValue()
        self.display.Clear()
        self.display.SetValue(formula[:-1])
        self.display.SetFocus()
        

    def OnDivide(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('*')
        self.display.SetFocus()
        

    def OnMultiply(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('*')
        self.display.SetFocus()
        

    def OnMinus(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('-')
        self.display.SetFocus()
        

    def OnPlus(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('+')
        self.display.SetFocus()
        

    def OnDot(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        self.display.AppendText('.')
        self.display.SetFocus()
        

    def OnEqual(self, event):
        """
        ...    
        """
        
        if self.formula:
            return
        formula = self.display.GetValue()
        self.formula = False
        try:
            self.display.Clear()
            output = eval(formula)
            self.display.AppendText(str(output))
        except SyntaxError:  # StandardError
            self.display.AppendText("Error")
            self.display.SetFocus()
            

    def OnZero(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('0')
        self.display.SetFocus()
        

    def OnOne(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('1')
        self.display.SetFocus()
        

    def OnTwo(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('2')
        self.display.SetFocus()
        

    def OnThree(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('3')
        self.display.SetFocus()
        

    def OnFour(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('4')
        self.display.SetFocus()
        

    def OnFive(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('5')
        self.display.SetFocus()
        

    def OnSix(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('6')
        self.display.SetFocus()
        

    def OnSeven(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('7')
        self.display.SetFocus()
        

    def OnEight(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('8')
        self.display.SetFocus()
        

    def OnNine(self, event):
        """
        ...    
        """
        
        if self.formula:
            self.display.Clear()
            self.formula = False
        self.display.AppendText('9')
        self.display.SetFocus()
        

    def OnKeyUp(self, event):
        """
        Handles the wx.EVT_CHAR_HOOK event for the dialog.
        """

        if event.GetKeyCode() == wx.WXK_ESCAPE:
            # Close the dialog, no action
            self.OnClose(event)

        event.Skip()

        
    def OnClose(self, event):
        """
        ...    
        """
        
        self.Close()

        
    def OnCloseWindow(self, event):
        """
        ...    
        """
        
        self.GetParent().Enable(True)
        self.__eventLoop.Exit()
        self.Destroy()

#-------------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self):
        super(MyFrame, self).__init__(None,
                                      -1,
                                      title="")

        #------------

        # Simplified init method.
        self.SetProperties()
        self.CreateCtrls()
        self.BindEvents()
        self.DoLayout()

        #------------

        self.CenterOnScreen()

    #-----------------------------------------------------------------------

    def SetProperties(self):
        """
        ...
        """

        self.SetTitle("Sample one")
        self.SetIcon(wx.Icon('icons/wxwin.ico'))


    def CreateCtrls(self):
        """
        ...
        """

        self.panel = wx.Panel(self, -1)

        self.btnDlg = wx.Button(self.panel,
                                -1,
                                "&Show customized calculator frame")

        self.btnClose = wx.Button(self.panel,
                                  -1,
                                  "&Close")


    def BindEvents(self):
        """
        Bind some events to an events handler.
        """

        # Bind the buttons event to an event handler.
        self.Bind(wx.EVT_CLOSE, self.OnCloseWindow)

        self.Bind(wx.EVT_BUTTON, self.OnThanksDlg, self.btnDlg)
        self.Bind(wx.EVT_BUTTON, self.OnCloseMe, self.btnClose)


    def DoLayout(self):
        """
        ...
        """

        # mainSizer is the top-level one that manages everything.
        mainSizer = wx.BoxSizer(wx.VERTICAL)

        # wx.BoxSizer(window, proportion, flag, border)
        # wx.BoxSizer(sizer, proportion, flag, border)
        mainSizer.Add(self.btnDlg, 1, wx.EXPAND | wx.ALL, 10)
        mainSizer.Add(self.btnClose, 1, wx.EXPAND | wx.ALL, 10)

        # Finally, tell the panel to use the sizer for layout.
        self.panel.SetAutoLayout(True)
        self.panel.SetSizer(mainSizer)

        mainSizer.Fit(self.panel)


    def OnCloseMe(self, event):
        """
        ...
        """

        self.Close(True)


    def OnThanksDlg(self, event):
        """
        ...
        """

        frame = MyCalculator(self, -1, 'Calculator')
        

    def OnCloseWindow(self, event):
        """
        ...
        """

        self.Destroy()

#-------------------------------------------------------------------------------

class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame()
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
