# sample_nine.py

"""

Experiments with wxPython's wx.Notebook() widget.
Author : Vegaseat
Converting distance, area and volume units
Tested with Python25 and wxPython28 - 11aug2008
Tested with Python3.x and wxPython4.x

"""

import wx

# class MyNotebook
# class MyPage

#---------------------------------------------------------------------------
        
# These are the conversion dictionaries ...
# (note that units won't appear in that order)
distD ={}

# All scale factors are relative to the first unit below
distD['meter'] = 1.0
distD['micron'] = 1000000.0
distD['millimeter'] = 1000.0
distD['centimeter'] = 100.0
distD['kilometer'] = 0.001
distD['inch'] = 100.0/2.54
distD['foot'] = 100.0/30.48
distD['yard'] = 100.0/91.44
distD['mile'] = 0.001/1.609344
distD['rod'] = 1.0/5.029


areaD = {}

# All scale factors are relative to the first unit below
areaD['sq meter'] = 1.0
areaD['sq millimeter'] = 1000000.0
areaD['sq centimeter'] = 10000.0
areaD['sq kilometer']  = 0.000001
areaD['hectare'] = 0.0001
areaD['sq inch'] = 1550.003
areaD['sq foot'] = 10.76391
areaD['sq yard'] = 1.19599
areaD['acre'] = 0.0002471054
areaD['sq mile'] = 0.0000003861022


volD = {}

# All scale factors are relative to the first unit below
volD['cubic meter'] = 1.0
volD['microliter'] = 1000000000.0
volD['milliliter'] = 1000000.0
volD['liter'] = 1000.0
volD['pint(US)'] = 2113.376
volD['quart(US)'] = 1056.688
volD['gallon(US)'] = 264.172
volD['cubic inch'] = 61023.74
volD['cubic foot'] = 35.31467
volD['cubic yard'] = 1.307951

#---------------------------------------------------------------------------

class MyNotebook(wx.Frame):
    def __init__(self, parent, title, distD, areaD, volD):
        wx.Frame.__init__(self, parent, wx.ID_ANY, title,
                          size=(490, 400))

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        # style=wx.NB_TOP is default
        # Could use style=wx.NB_BOTTOM
        nb = wx.Notebook(self, wx.ID_ANY)
        
        # MyPage(parent, conversion dictionary, preselected choice)
        self.page1 = MyPage(nb, distD, 3)
        self.page2 = MyPage(nb, areaD, 2)
        self.page3 = MyPage(nb, volD, 0)
        nb.AddPage(self.page1, "Distance Conversion")
        nb.AddPage(self.page2, "Area Conversion")
        nb.AddPage(self.page3, "Volume Conversion")
        
        # Start with page1 active
        self.page1.SetFocus()

#---------------------------------------------------------------------------
        
class MyPage(wx.Panel):
    """
    each panel instance creates the notbook page content
    from the given conversion dictionary convD
    """
    def __init__(self, parent, convD, preselect):
        wx.Panel.__init__(self, parent, wx.ID_ANY)
        
        oatmeal3 = '#FCFFE1'
        self.SetBackgroundColour(oatmeal3)

        self.convD = convD
        # print("convD :", self.convD)

        #------------
        
        # Create list of possible units
        items = convD.keys()
        self.options = (list(items))
        
        self.radiobox1 = wx.RadioBox(self, wx.ID_ANY,
                                     "Select a unit to convert from",
                                     choices=self.options, style=wx.VERTICAL)
        # Set radio button 1 as selected (first button is 0)
        self.radiobox1.SetSelection(preselect)
        # Bind mouse click to an action
        self.radiobox1.Bind(wx.EVT_RADIOBOX, self.onAction)

        self.radiobox2 = wx.RadioBox(self, wx.ID_ANY,
                                     "Select a unit to convert to  ",
                                     choices=self.options, style=wx.VERTICAL)
        # Set radio button 1 as selected (first button is 0)
        self.radiobox2.SetSelection(preselect)
        # Bind mouse click to an action
        self.radiobox2.Bind(wx.EVT_RADIOBOX, self.onAction)

        # Additional widgets
        self.label1 = wx.StaticText(self, wx.ID_ANY, "" )
        self.label2 = wx.StaticText(self, wx.ID_ANY, "" )

        self.edit1 = wx.TextCtrl(self, wx.ID_ANY, value="1.0",
                                 size=(150, 20), style=wx.TE_PROCESS_ENTER)
        # Respond to enter key when focus is on edit1
        self.edit1.Bind(wx.EVT_TEXT_ENTER, self.onAction)

        self.edit2 = wx.TextCtrl(self, wx.ID_ANY, value="",
            size=(150, 20), style=wx.TE_PROCESS_ENTER)

        self.button = wx.Button(self, wx.ID_ANY, label='Convert')
        self.button.Bind(wx.EVT_BUTTON, self.onAction)

        #------------
        
        # Use box sizers to layout the widgets
        # Nest the 3 vertical sizers in the horizontal sizer later
        sizer_v1 = wx.BoxSizer(wx.VERTICAL)
        sizer_v2 = wx.BoxSizer(wx.VERTICAL)
        sizer_v3 = wx.BoxSizer(wx.VERTICAL)
        sizer_h = wx.BoxSizer(wx.HORIZONTAL)
        # Add the widgets to the corresponding vertical sizer
        sizer_v1.Add(self.radiobox1, 0, flag=wx.ALL, border=10)
        sizer_v1.Add(self.label1, 0, wx.LEFT|wx.RIGHT|wx.TOP, 10)
        sizer_v1.Add(self.edit1, 0, wx.LEFT|wx.RIGHT, 10)
        # Add a spacer to position the button lower ...
        sizer_v2.Add((0, 225), 0, wx.ALL, 10)
        sizer_v2.Add(self.button, 0, wx.ALL, 10)
        sizer_v3.Add(self.radiobox2, 0, wx.ALL, 10)
        sizer_v3.Add(self.label2, 0, wx.LEFT|wx.RIGHT|wx.TOP, 10)
        sizer_v3.Add(self.edit2, 0, wx.LEFT|wx.RIGHT, 10)
        # Put the 3 vertical sizers into the horizontal sizer
        sizer_h.Add(sizer_v1, 0)
        sizer_h.Add(sizer_v2, 0)
        sizer_h.Add(sizer_v3, 0)
        
        # It's the horizontal sizer you have to set
        self.SetSizer(sizer_h)

        #------------
        
        # Show present selection
        self.onAction(None)

    #-----------------------------------------------------------------------

    def onAction(self, event):
        """
        Show the selected choice.
        """
        
        index1 = self.radiobox1.GetSelection()
        unit1 = self.options[index1]
        # print(unit1)  # test
        
        s = "Enter a value (%s):" % unit1
        self.label1.SetLabel(s)
        
        # Dito for radio box #2
        index2 = self.radiobox2.GetSelection()
        unit2 = self.options[index2]
        
        # print(unit2)  # test
        s = "Result (%s):" % unit2
        self.label2.SetLabel(s)

        value = float(self.edit1.GetValue())
        factor1 = self.convD[unit1]
        factor2 = self.convD[unit2]
        result = factor2 * value/factor1
        self.edit2.ChangeValue(str(result))

#---------------------------------------------------------------------------

app = wx.App(True)
frm = MyNotebook(None, "Converting distance, area and volume units",
                 distD, areaD, volD)
frm.SetDoubleBuffered(True)
frm.Show(True)
app.MainLoop()

