# sample_five.py

"""

Author : Sneekula
Do some simple math operations with
wx.Choice(parent,id,pos,size,choices,style)
https://www.daniweb.com/programming/software-development/threads/128350/starting-wxpython-gui-code/3#post1823238


"""

import wx
from math import *

#---------------------------------------------------------------------------

# List of math operations Python understands
# x and/or y values are pulled from the edit boxes

operation_list = [
'x + y',
'x - y',
'x * y',
'x / y',
'x**y',
'sqrt(x)',
'exp(x)', 
'log(x)', 
'log10(x)', 
'degrees(x)',
'radians(x)',
'sin(x)',
'cos(x)',
'tan(x)',
'asin(x)',
'acos(x)',
'atan(x)'
]

# class MyFrame

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, title, operation_list):
        wx.Frame.__init__(self, parent, wx.ID_ANY, title, size=(350, 270))

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        self.SetBackgroundColour('green')

        #------------
        
        # Create choice widget for the math operations
        self.choice = wx.Choice(self, wx.ID_ANY, choices=operation_list)
        # Select item 0 (first item) in choices list to show
        self.choice.SetSelection(0)
        self.choice.SetToolTip(wx.ToolTip('Select one math operation'))
        # Bind the checkbox events to action
        self.choice.Bind(wx.EVT_CHOICE, self.onAction)
        
        edit_label1 = wx.StaticText(self, wx.ID_ANY, 'Enter x :')
        self.edit1 = wx.TextCtrl(self, wx.ID_ANY, value="1", size=(200, 20))
        
        edit_label2 = wx.StaticText(self, wx.ID_ANY, 'Enter y :')
        self.edit2 = wx.TextCtrl(self, wx.ID_ANY, value="1", size=(200, 20))
            
        edit_label3 = wx.StaticText(self, wx.ID_ANY, 'Result :')
        self.edit3 = wx.TextCtrl(self, wx.ID_ANY, value="", size=(200, 20))
        self.edit3.SetToolTip(wx.ToolTip('Double click to move data to x'))
        self.edit3.Bind(wx.EVT_LEFT_DCLICK, self.onDoubleClick)
        
        self.button = wx.Button(self, wx.ID_ANY, label='Calculate')
        # Bind mouse event to action
        self.button.Bind(wx.EVT_BUTTON, self.onAction)

        #------------
        
        # Hgap is between columns, vgap between rows
        sizer = wx.GridBagSizer(vgap=0, hgap=0)
        
        # Pos=(row, column)
        sizer.Add(edit_label1, pos=(0,0), flag=wx.ALL|wx.EXPAND, border=10)
        sizer.Add(self.edit1, pos=(0,1), flag=wx.ALL|wx.EXPAND, border=10)
        sizer.Add(edit_label2, pos=(1,0), flag=wx.ALL|wx.EXPAND, border=10)
        sizer.Add(self.edit2, pos=(1,1), flag=wx.ALL|wx.EXPAND, border=10)
        # Span=(rowspan, columnspan)
        sizer.Add(self.choice, pos=(2,0), span=(1, 2), flag=wx.ALL|wx.EXPAND, border=10)
        sizer.Add(self.button, pos=(3,0), span=(1, 2), flag=wx.ALL|wx.EXPAND, border=10)
        sizer.Add(edit_label3, pos=(4,0), flag=wx.ALL|wx.EXPAND, border=10)
        sizer.Add(self.edit3, pos=(4,1), flag=wx.ALL|wx.EXPAND, border=10)

        self.SetSizerAndFit(sizer)

    #-----------------------------------------------------------------------
        
    def onAction(self, event):
        """
        ...
        """
        
        op = self.choice.GetStringSelection()
        x = float(self.edit1.GetValue())
        y = float(self.edit2.GetValue())
        
        if y == 0.0 and op == 'x / y' :
            result = 'division by zero error'
        else:
            result = eval(op)
            
        # Print result, type(result)
        self.edit3.SetValue(str(result))

        
    def onDoubleClick(self, event):
        """
        If edit3 has been doubleclicked, transfer value to edit1
        """
        
        val = self.edit3.GetValue()
        self.edit1.ChangeValue(val)

#---------------------------------------------------------------------------

app = wx.App(0)
# Create the MyFrame instance and show it
MyFrame(None, 'Do math stuff', operation_list).Show()
app.MainLoop()
