# sample_eight.py

"""

A simple mortgage calulator using wxPython.
Author : Lardmeister
Checked it out with the online mortgage calculator at:
http://www.mortgage-calc.com/mortgage/simple.php
https://www.daniweb.com/programming/software-development/threads/128350/starting-wxpython-gui-code#post626319

"""

import wx
import math

# class MyFrame

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    """
    Frame and widgets to handle input and output of mortgage calc.
    """
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        # Add panel, labels, text and sizer widgets
        panel = wx.Panel(self, -1)
        panel.SetBackgroundColour('orange')
        
        label1 = wx.StaticText(panel, -1, "Enter total loan amount :")
        label2 = wx.StaticText(panel, -1, "Enter annual interest (%) :")
        label3 = wx.StaticText(panel, -1, "Enter years to pay :")

        label1.SetForegroundColour('white')
        label2.SetForegroundColour('white')
        label3.SetForegroundColour('white')
        
        self.loan = wx.TextCtrl(panel, -1, "100000")
        self.interest = wx.TextCtrl(panel, -1, "6.5")
        self.years = wx.TextCtrl(panel, -1, "30")
        
        self.calc_btn = wx.Button(panel, -1, ' Perform Mortgage Calculation ')
        self.calc_btn.SetBackgroundColour('light blue')
        self.calc_btn.Bind(wx.EVT_BUTTON, self.onCalc)
        
        info = "Modify the above data to your needs !"
        self.result = wx.TextCtrl(panel, -1, info, size=(290, 100),
                                  style=wx.TE_MULTILINE)

        #------------
        
        # Use gridbagsizer for layout of widgets
        sizer = wx.GridBagSizer(vgap=5, hgap=10)
        sizer.Add(label1, pos=(0, 0))
        sizer.Add(self.loan, pos=(0, 1))  # row 0, column 1
        sizer.Add(label2, pos=(1, 0))
        sizer.Add(self.interest, pos=(1, 1))
        sizer.Add(label3, pos=(2, 0))
        sizer.Add(self.years, pos=(2, 1))
        sizer.Add(self.calc_btn, pos=(3, 0), span=(1, 2))
        # Span=(1, 2) --> allow to span over 2 columns 
        sizer.Add(self.result, pos=(4, 0), span=(1, 2))
        
        # Use boxsizer to add border around sizer
        border = wx.BoxSizer()
        border.Add(sizer, 0, wx.ALL, 20)
        panel.SetSizerAndFit(border)
        
        self.Fit()

    #-----------------------------------------------------------------------
        
    def onCalc(self, event):
        """
        Do the mortgage calcuations.
        """
        
        # Get the values from the input widgets
        principal = float(self.loan.GetValue())
        interest = float(self.interest.GetValue())
        years = float(self.years.GetValue())
        
        # Calculate        
        interestRate = interest/(100 * 12)
        paymentNum = years * 12
        paymentVal = principal * \
                     (interestRate/(1-math.pow((1+interestRate), (-paymentNum))))

        # Show the result
        resultStr1 = "Your monthly payment will be $%.2f for\n" % paymentVal
        resultStr2 = "a %.1f year $%.2f loan at %.2f%s interest" % \
                     (years, principal, interest, '%') 
        self.result.SetValue(resultStr1 + resultStr2) 
        
#---------------------------------------------------------------------------
        
app = wx.App()
frame = MyFrame(None, -1, "Mortgage calculator")
frame.Show()
app.MainLoop()
