# sample_one.py

"""

Author : Jan Bodnar
Website : zetcode.com

"""

import wx
import random

APP_SIZE_X = 300
APP_SIZE_Y = 200

# class MyButtons

#---------------------------------------------------------------------------

class MyButtons(wx.Dialog):
    def __init__(self, parent, id, title):
        wx.Dialog.__init__(self, parent, id, title,
                           size=(APP_SIZE_X, APP_SIZE_Y))

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        wx.Button(self, 1, '&Close', (50, 130))
        wx.Button(self, 2, '&Random Move', (150, 130), (110, -1))

        #------------
        
        self.Bind(wx.EVT_BUTTON, self.OnClose, id=1)
        self.Bind(wx.EVT_BUTTON, self.OnRandomMove, id=2)

        #------------
        
        self.Centre()

        #------------
        
        self.ShowModal()
        self.Destroy()

    #-----------------------------------------------------------------------
        
    def OnClose(self, event):
        self.Close(True)


    def OnRandomMove(self, event):
        screensize = wx.GetDisplaySize()
        randx = random.randrange(0, screensize.x - APP_SIZE_X)
        randy = random.randrange(0, screensize.y - APP_SIZE_Y)
        self.Move((randx, randy))

#---------------------------------------------------------------------------
        
app = wx.App(0)
MyButtons(None, -1, 'wx.Button')
app.MainLoop()
