# Sample_four.py

"""

https://maku77.github.io/python/wxpython/layout.html

sizer = wx.BoxSizer(wx.HORIZONTAL)
sizer = wx.BoxSizer(wx.VERTICAL)

"""

import wx

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, None, -1, title, size=(350, 150))

        self.SetIcon(wx.Icon('./icons/wxwin.ico', wx.BITMAP_TYPE_ICO))

        #------------
        
        self.InitializeComponents()

    #-----------------------------------------------------------------------

    def InitializeComponents(self):
        mainPanel = wx.Panel(self)
        
        button1 = wx.Button(mainPanel, -1, "Button 1")
        button2 = wx.Button(mainPanel, -1, "Button 2")
        button3 = wx.Button(mainPanel, -1, "Button 3")

        #------------
        
        # Create a sizer.
        sizer = wx.BoxSizer(wx.HORIZONTAL)
        
        sizer.Add(button1, 1)
        sizer.Add(button2, 1)
        sizer.Add(button3, 2)
        
        mainPanel.SetSizer(sizer)

#---------------------------------------------------------------------------
        
class MyApp(wx.App):
    def OnInit(self):
        frame = MyFrame(None, -1, "wx.BoxSizer (proportion)")
        frame.Show(True)
        
        return True
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(redirect=False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
