# sample_two.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, *args, **kwargs):
        wx.Panel.__init__(self, *args, **kwargs)
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

    #-----------------------------------------------------------------------
        
    def OnPaint(self, event):
        """
        ...
        """

        pdc = wx.PaintDC(self)
        gc = wx.GCDC(pdc)
        gc.Clear()

        #------------
        # Bitmap.
        #------------
        
        x = 100 
        y = 30

        # bmp, pt, useMask=False
        # or
        # bitmap, x, y, useMask=False
        gc.DrawBitmap(wx.Bitmap("./Bitmaps/python.png"), x, y, True)
        gc.DrawText("Bitmap", int(x+150), int(y+20))
        
        #------------
        # Icon.
        #------------
        
        x = 100 
        y = 130

        # icon, pt
        # or
        # icon, x, y
        gc.DrawIcon(wx.Icon("./icons/icon_wxWidgets.ico"), x, y)
        gc.DrawText("Icon", int(x+75), int(y+20))
       
        #------------        
        # Arc.
        #------------
        
        gc.SetPen(wx.Pen("black", 2))
        gc.SetBrush(wx.Brush((204, 85, 248, 128)))
        
        x1 = 100 
        y1 = 260
        x2 = 340 
        y2 = 335        
        x = 160
        y = 220

        # ptStart, ptEnd, centre
        # or
        # xStart, yStart, xEnd, yEnd, xc, yc
        gc.DrawArc(x1, y1, x2, y2, x, y)
        gc.DrawText("Arc", int(x+80), int(y+30))

        #------------        
        # Polygon.
        #------------
        
        gc.SetPen(wx.Pen("blue", 2))   
        gc.SetBrush(wx.Brush("#cacaca"))

        points = [(80, 140),
                  (130, 170),
                  (130, 140),
                  (170, 110)
                  ]
        x = 20
        y = 220
        
        # points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE
        gc.DrawPolygon(points, x, y)
        gc.DrawText("Polygon", int(x+150), int(y+140))

        #------------        
        # Spline.
        #------------
        
        gc.SetPen(wx.Pen("red", 2))
        gc.SetBrush(wx.Brush("pink"))

        points = [(100, 435),
                  (140, 435),
                  (145, 495),
                  (185, 495)
                  ]

        # x1, y1, x2, y2, x3, y3
        # or
        # points    
        gc.DrawSpline(points)
        gc.DrawText("Spline", int(x+180), int(y+250))

        #------------        
        # Point.
        #------------
        
        gc.SetPen(wx.Pen("purple", 80))
        
        x = 100 
        y = 555

        # pt
        # or
        # x, y
        gc.DrawPoint (x, y)
        gc.DrawText("Point", int(x+20), int(y-10))

        #------------
        # Text.
        #------------
        
        x = 150 
        y = 620

        gc.DrawText("Text", int(x+100), int(y))

        gc.SetTextForeground("red")
        font = wx.Font(36, wx.ROMAN, wx.ITALIC, wx.NORMAL) 
        gc.SetFont(font)

        # text, pt
        # or 
        # text, x, y
        gc.DrawText("Hello !", x-50, y-20)

        
#---------------------------------------------------------------------------
            
class MyFrame(wx.Frame):
    def __init__(self, *args, **kwargs):
        wx.Frame.__init__(self, *args, **kwargs)

        #------------
        
        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))

        #------------
        
        self.Panel = MyPanel(self)
        
#---------------------------------------------------------------------------


class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame(None, title="Sample_two", size=(380, 750))
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------  

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
