# sample_three.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, *args, **kwargs):
        wx.Panel.__init__(self, *args, **kwargs)
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

    #-----------------------------------------------------------------------
        
    def OnPaint(self, event):
        """
        ...
        """

        pdc = wx.PaintDC(self)
        gc = wx.GCDC(pdc)
        gc.Clear()

        #------------
        # Elliptic arc.
        #------------      

        pen = wx.Pen("black", 2, wx.SOLID)
        pen.SetCap(wx.CAP_BUTT)
        gc.SetPen(pen)
        gc.SetBrush(wx.GREEN_BRUSH)
        
        x = 100
        y = 30
        w = 50
        h = 50
        r = 270

        # pt, sz, sa, ea
        # or
        # x, y , width, height, start, end
        gc.DrawEllipticArc(x, y, w, h, 0, r)
        gc.DrawText("Elliptic arc", int(x+w+10), int(y+h/2))

        #------------
        # Lines.
        #------------

        gc.SetPen(wx.Pen("purple", 4))
        
        points = [(20, 160),
                  (100, 160),
                  (20, 110),
                  (100, 110)
                  ]
        x = 90
        y = 20

        # points, xoffset=0, yoffset=0     
        gc.DrawLines(points, x, y)
        gc.DrawText("Lines", int(x+120), int(y+125))

        #------------        
        # Gradient fill linear.
        #------------

        x = 100
        y = 240
        w = 100
        h = 100
        
        gc.GradientFillLinear((x, y, w, h),
                              "#ff6b1a",
                              "#000000",
                              wx.NORTH)
        # rect, initialColour, destColour, nDirection=RIGHT)
        gc.DrawText("Gradient fill linear", int(x+115), int(y+40))

        #------------        
        # Gradient fill concentric.
        #------------

        x = 100
        y = 380
        w = 100
        h = 100


        # Note : currently this function is very slow,
        # don’t use it for real-time drawing.
        
        # rect, initialColour, destColour
        # or
        # rect, initialColour, destColour
        gc.GradientFillConcentric((x, y, w, h),
                                  "#61c3ff",
                                  "#000000",
                                  (50, 50))
        # rect, initialColour, destColour, circleCenter)
        gc.DrawText("Gradient fill concentric", int(x+115), int(y+40))
        
#---------------------------------------------------------------------------
            
class MyFrame(wx.Frame):
    def __init__(self, *args, **kwargs):
        wx.Frame.__init__(self, *args, **kwargs)

        #------------
        
        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))

        #------------
        
        self.Panel = MyPanel(self)
        
#---------------------------------------------------------------------------


class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame(None, title="Sample_three", size=(380, 580))
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------  

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
