# sample_ten.py

"""

ZetCode wxPython tutorial.

This program draws three rectangles 
with custom brush patterns.

Author: Jan Bodnar
Website: zetcode.com
Last edited: May 2018
Link : http://zetcode.com/wxpython/gdi/

"""

import wx

# class Example
# def main

#---------------------------------------------------------------------------

class Example(wx.Frame):
    def __init__(self, *args, **kw):
        super(Example, self).__init__(*args, **kw)

        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        """
        ...
        """
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))
        self.SetTitle("Sample_ten (custom patterns)")
        self.SetSize((400, 140))
        self.SetMinSize((400, 140))
        self.SetBackgroundColour("white")
        self.Centre()


    def OnPaint(self, event):
        """
        ...
        """
        
        dc = wx.PaintDC(self)

        dc.SetPen(wx.Pen('#C7C3C3'))

        brush1 = wx.Brush(wx.Bitmap('./Bitmaps/pattern1.png'))
        dc.SetBrush(brush1)
        dc.DrawRectangle(35, 15, 90, 60)

        brush2 = wx.Brush(wx.Bitmap('./Bitmaps/pattern2.png'))
        dc.SetBrush(brush2)
        dc.DrawRectangle(147, 15, 90, 60)

        brush3 = wx.Brush(wx.Bitmap('./Bitmaps/pattern3.png'))
        dc.SetBrush(brush3)
        dc.DrawRectangle(259, 15, 90, 60)

#---------------------------------------------------------------------------
        
def main():
    app = wx.App()
    ex = Example(None)
    ex.Show()
    app.MainLoop()

#---------------------------------------------------------------------------
    
if __name__ == '__main__':
    main()
