# sample_six.py

"""

ZetCode wxPython tutorial.

This program draws uses different 
joins and caps in drawing.

Author : Jan Bodnar
Website : zetcode.com
Last edited : May 2018
Link : http://zetcode.com/wxpython/gdi/

"""

import wx

# class Example
# def main

#---------------------------------------------------------------------------

class Example(wx.Frame):
    def __init__(self, *args, **kw):
        super(Example, self).__init__(*args, **kw)

        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        """
        ...
        """
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))
        self.SetTitle("Sample_six (joins and caps)")
        self.SetSize((350, 310))
        self.SetMinSize((350, 310))
        self.SetBackgroundColour("#8de578")
        self.Centre()


    def OnPaint(self, event):
        """
        ...
        """
        
        dc = wx.PaintDC(self)
        dc = wx.GCDC(dc)

        pen = wx.Pen('#4c4c4c', 10, wx.SOLID)

        pen.SetJoin(wx.JOIN_MITER)
        dc.SetPen(pen)
        dc.DrawRectangle(15, 15, 80, 50)

        pen.SetJoin(wx.JOIN_BEVEL)
        dc.SetPen(pen)
        dc.DrawRectangle(125, 15, 80, 50)

        pen.SetJoin(wx.JOIN_ROUND)
        dc.SetPen(pen)
        dc.DrawRectangle(235, 15, 80, 50)

        pen.SetCap(wx.CAP_BUTT)
        dc.SetPen(pen)
        dc.DrawLine(30, 150,  150, 150)

        pen.SetCap(wx.CAP_PROJECTING)
        dc.SetPen(pen)
        dc.DrawLine(30, 190,  150, 190)

        pen.SetCap(wx.CAP_ROUND)
        dc.SetPen(pen)
        dc.DrawLine(30, 230,  150, 230)

        pen2 = wx.Pen('gray', 1, wx.SOLID)
        dc.SetPen(pen2)
        dc.DrawLine(30, 130, 30, 250)
        dc.DrawLine(150, 130, 150, 250)
        dc.DrawLine(155, 130, 155, 250)

#---------------------------------------------------------------------------

def main():
    app = wx.App()
    ex = Example(None)
    ex.Show()
    app.MainLoop()

#---------------------------------------------------------------------------
    
if __name__ == '__main__':
    main()
