# sample_seven.py

"""

ZetCode wxPython tutorial.

This program draws six rectangles
with different pens.

Author : Jan Bodnar
Website : zetcode.com
Last edited : May 2018
Link : http://zetcode.com/wxpython/gdi/

"""

import wx

# class Example
# def main

#---------------------------------------------------------------------------

class Example(wx.Frame):
    def __init__(self, *args, **kw):
        super(Example, self).__init__(*args, **kw)

        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        """
        ...
        """
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))
        self.SetTitle("Sample_seven (pens)")
        self.SetSize((370, 310))
        self.SetMinSize((370, 310))
        self.SetBackgroundColour("#e1e0d9")
        self.Centre()


    def OnPaint(self, event):
        """
        ...
        """
        
        dc = wx.PaintDC(self)
        dc = wx.GCDC(dc)

        dc.SetPen(wx.Pen('#4c4c4c', 2, wx.SOLID))
        dc.DrawRectangle(10, 15, 90, 60)

        dc.SetPen(wx.Pen('#4c4c4c', 2, wx.DOT))
        dc.DrawRectangle(130, 15, 90, 60)

        dc.SetPen(wx.Pen('#4c4c4c', 2, wx.LONG_DASH))
        dc.DrawRectangle(250, 15, 90, 60)

        dc.SetPen(wx.Pen('#4c4c4c', 2, wx.SHORT_DASH))
        dc.DrawRectangle(10, 105, 90, 60)

        dc.SetPen(wx.Pen('#4c4c4c', 2, wx.DOT_DASH))
        dc.DrawRectangle(130, 105, 90, 60)

        dc.SetPen(wx.Pen('#4c4c4c', 2, wx.TRANSPARENT))
        dc.DrawRectangle(250, 105, 90, 60)

        pen = wx.Pen('#4c4c4c', 2, wx.PENSTYLE_USER_DASH)
        pen.SetDashes([2, 5, 2, 2]) 
        dc.SetPen(pen) 
        dc.DrawRectangle(10, 195, 90, 60)
          
#---------------------------------------------------------------------------
        
def main():
    app = wx.App()
    ex = Example(None)
    ex.Show()
    app.MainLoop()

#---------------------------------------------------------------------------
    
if __name__ == '__main__':
    main()
