# sample_one.py

import wx

# class MyPanel
# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyPanel(wx.Panel):
    def __init__(self, *args, **kwargs):
        wx.Panel.__init__(self, *args, **kwargs)
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

    #-----------------------------------------------------------------------
        
    def OnPaint(self, event):
        """
        ...
        """

        pdc = wx.PaintDC(self)
        gc = wx.GCDC(pdc)
        gc.Clear()

        #------------
        # Square.
        #------------
        
        gc.SetPen(wx.Pen("red", 2))
        gc.SetBrush(wx.Brush("yellow"))
        
        x = 100 
        y = 30
        w = 50
        h = 50

        # pt, sz
        # or
        # rect
        # or
        # x, y, width, height 
        gc.DrawRectangle(x , y, w, h)
        gc.DrawText("Square", int(x+w+10), int(y+h/2))

        #------------
        # Rectangle.
        #------------
        
        gc.SetPen(wx.Pen("black", 2))
        gc.SetBrush(wx.Brush((0, 255, 255, 255)))
        
        x = 100 
        y = 130
        w = 100
        h = 50

        # pt, sz
        # or
        # rect
        # or
        # x, y, width, height      
        gc.DrawRectangle(x , y, w, h)  
        gc.DrawText("Rectangle", int(x+w+10), int(y+h/2))

        #------------        
        # Rounded rectangle.
        #------------
        
        gc.SetPen(wx.Pen("black", 2))
        gc.SetBrush(wx.Brush((255, 0, 255, 128)))
        
        x = 100 
        y = 230
        w = 100
        h = 50
        r = 8

        # pt, sz, radius
        # or
        # rect, radius
        # or
        # x, y, width, height, radius)
        gc.DrawRoundedRectangle(x, y, w, h, r)
        gc.DrawText("Rounded rectangle", int(x+w+10), int(y+h/2))

        #------------        
        # Ellipse.
        #------------
        
        gc.SetPen(wx.Pen("gray", 2))
        gc.SetBrush(wx.Brush("green"))
        
        x = 100 
        y = 330
        w = 100
        h = 50

        # pt, size
        # or
        # rect
        # or 
        # x, y, width, height
        gc.DrawEllipse(x, y, w, h)
        gc.DrawText("Ellipse", int(x+w+10), int(y+h/2))

        #------------        
        # Circle.
        #------------
        
        gc.SetPen(wx.Pen("red", 2))
        gc.SetBrush(wx.Brush("#ffc0cb"))
        
        x = 130 
        y = 455
        r = 35

        # pt, radius
        # or
        # x, y, radius
        gc.DrawCircle(x, y, r)
        gc.DrawText("Circle", int(x+45), int(y))

        #------------        
        # Line.
        #------------
        
        gc.SetPen(wx.Pen("purple", 4))
        
        x1 = 100 
        y1 = 545 
        x2 = 200        
        y2 = 545

        # pt1, pt2
        # or
        # x1, y1, x2, y2
        gc.DrawLine(x1, y1, x2, y2)
        gc.DrawText("Line", int(x+w-10), int(y+80))

        #------------        
        # Triangle.
        #------------
        
        gc.SetPen(wx.Pen("blue", 2))
        gc.SetBrush(wx.Brush((150, 150, 150, 128)))
        
        points = [(80, 80),
                  (10, 10),
                  (80, 10),
                  (80, 80)
                  ]
        x = 90
        y = 580         

        # points, xoffset=0, yoffset=0, fill_style=ODDEVEN_RULE
        gc.DrawPolygon(points, x, y)
        gc.DrawText("Triangle", int(x+w-5), int(y+h/2))
        
#---------------------------------------------------------------------------
            
class MyFrame(wx.Frame):
    def __init__(self, *args, **kwargs):
        wx.Frame.__init__(self, *args, **kwargs)

        #------------
        
        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))

        #------------
        
        self.Panel = MyPanel(self)
        
#---------------------------------------------------------------------------


class MyApp(wx.App):
    """
    ...
    """
    def OnInit(self):

        #------------

        frame = MyFrame(None, title="Sample_one", size=(380, 750))
        self.SetTopWindow(frame)
        frame.Show(True)

        return True

#---------------------------------------------------------------------------  

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()
