# sample_nine.py

"""

ZetCode wxPython tutorial.

This program draws eight rectangles 
filled with different brushes.

Author: Jan Bodnar
Website: zetcode.com
Last edited: May 2018
Link : http://zetcode.com/wxpython/gdi/

"""

import wx

# class Example
# def main

#---------------------------------------------------------------------------

class Example(wx.Frame):
    def __init__(self, *args, **kw):
        super(Example, self).__init__(*args, **kw)

        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        """
        ...
        """
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))
        self.SetTitle("Sample_nine (brushes)")
        self.SetSize((400, 310))
        self.SetMinSize((400, 310))
        self.SetBackgroundColour("#78c2e5")
        self.Centre()


    def OnPaint(self, event):
        """
        ...
        """
        
        dc = wx.PaintDC(self)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.CROSS_HATCH))
        dc.DrawRectangle(35, 15, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.SOLID))
        dc.DrawRectangle(147, 15, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.BDIAGONAL_HATCH))
        dc.DrawRectangle(259, 15, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.CROSSDIAG_HATCH))
        dc.DrawRectangle(35, 105, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.FDIAGONAL_HATCH))
        dc.DrawRectangle(147, 105, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.HORIZONTAL_HATCH))
        dc.DrawRectangle(259, 105, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.VERTICAL_HATCH))
        dc.DrawRectangle(35, 195, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c', wx.TRANSPARENT))
        dc.DrawRectangle(147, 195, 90, 60)

#---------------------------------------------------------------------------
        
def main():
    app = wx.App()
    ex = Example(None)
    ex.Show()
    app.MainLoop()

#---------------------------------------------------------------------------
    
if __name__ == '__main__':
    main()
