# sample_five.py

"""

ZetCode wxPython tutorial.

This program performs set operations on regions.

Author      : Jan Bodnar
Website     : zetcode.com
link        : http://www.zetcode.com/wxpython/gdi/
Last edited : May 2018

--------

Region operations :

Regions can be combined to create more complex shapes.
We can use four set operations : union, intersect, substract, xor.

The following example shows all four operations in action.

--------

In the example, we present six region set operations.

region1 = wx.Region(100, 20, 50, 50)
region2 = wx.Region(110, 40, 50, 50)
region1.Intersect(region2)

"""

import wx

# class MyFrame
# class MyApp

#---------------------------------------------------------------------------

class MyFrame(wx.Frame):
    def __init__(self, *args, **kw):
        super(MyFrame, self).__init__(*args, **kw)

        #------------
        
        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))   
        self.SetSize((300, 250))
        self.SetMinSize((300, 250))
        self.SetBackgroundColour("yellow")

        #------------

        # Simplified init method.        
        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        """
        ...
        """
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        self.SetTitle("Sample_five (regions)")
        self.Centre()


    def OnPaint(self, event):
        """
        ...
        """
        
        dc = wx.PaintDC(self)
        dc.SetPen(wx.Pen('#000000'))

        dc.DrawRectangle(20, 20, 50, 50)
        dc.DrawRectangle(30, 40, 50, 50)

        dc.SetBrush(wx.Brush('#ffffff'))
        dc.DrawRectangle(100, 20, 50, 50)
        dc.DrawRectangle(110, 40, 50, 50)

        region1 = wx.Region(100, 20, 50, 50)
        region2 = wx.Region(110, 40, 50, 50)
        region1.Intersect(region2)

        rect = region1.GetBox()
        dc.SetDeviceClippingRegion(region1)
        dc.SetBrush(wx.Brush('#ff0000'))
        dc.DrawRectangle(rect)
        dc.DestroyClippingRegion()

        dc.SetBrush(wx.Brush('#ffffff'))
        dc.DrawRectangle(180, 20, 50, 50)
        dc.DrawRectangle(190, 40, 50, 50)

        region1 = wx.Region(180, 20, 50, 50)
        region2 = wx.Region(190, 40, 50, 50)
        region1.Union(region2)
        dc.SetDeviceClippingRegion(region1)

        rect = region1.GetBox()
        dc.SetBrush(wx.Brush('#fa8e00'))
        dc.DrawRectangle(rect)
        dc.DestroyClippingRegion()

        dc.SetBrush(wx.Brush('#ffffff'))
        dc.DrawRectangle(20, 120, 50, 50)
        dc.DrawRectangle(30, 140, 50, 50)
        region1 = wx.Region(20, 120, 50, 50)
        region2 = wx.Region(30, 140, 50, 50)
        region1.Xor(region2)

        rect = region1.GetBox()
        dc.SetDeviceClippingRegion(region1)
        dc.SetBrush(wx.Brush('#619e1b'))
        dc.DrawRectangle(rect)
        dc.DestroyClippingRegion()

        dc.SetBrush(wx.Brush('#ffffff'))
        dc.DrawRectangle(100, 120, 50, 50)
        dc.DrawRectangle(110, 140, 50, 50)
        region1 = wx.Region(100, 120, 50, 50)
        region2 = wx.Region(110, 140, 50, 50)
        region1.Subtract(region2)

        rect = region1.GetBox()
        dc.SetDeviceClippingRegion(region1)
        dc.SetBrush(wx.Brush('#715b33'))
        dc.DrawRectangle(rect)
        dc.DestroyClippingRegion()

        dc.SetBrush(wx.Brush('#ffffff'))
        dc.DrawRectangle(180, 120, 50, 50)
        dc.DrawRectangle(190, 140, 50, 50)
        region1 = wx.Region(180, 120, 50, 50)
        region2 = wx.Region(190, 140, 50, 50)
        region2.Subtract(region1)

        rect = region2.GetBox()
        dc.SetDeviceClippingRegion(region2)
        dc.SetBrush(wx.Brush('#0d0060'))
        dc.DrawRectangle(rect)
        dc.DestroyClippingRegion()

#---------------------------------------------------------------------------

class MyApp(wx.App):    
    def OnInit(self):

        #------------

        frame = MyFrame(None)
        self.SetTopWindow(frame)
        frame.Show(True)

        return True
    
#---------------------------------------------------------------------------

def main():
    app = MyApp(False)
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == "__main__" :
    main()    
