#!/usr/bin/env python

"""

ZetCode wxPython tutorial.

This program draws nine coloured 
rectangles on the window.

Author: Jan Bodnar
Website: zetcode.com
Last edited: May 2018
Link : http://zetcode.com/wxpython/gdi/

"""

import wx

# class Example
# def main

#---------------------------------------------------------------------------

class Example(wx.Frame):
    def __init__(self, *args, **kw):
        super(Example, self).__init__(*args, **kw)

        self.InitUI()

    #-----------------------------------------------------------------------
        
    def InitUI(self):
        """
        ...
        """
        
        self.Bind(wx.EVT_PAINT, self.OnPaint)

        self.SetIcon(wx.Icon('./icons/icon_wxWidgets.ico'))
        self.SetTitle("Sample_eight (colours)")
        self.SetSize((400, 310))
        self.SetMinSize((400, 310))
        self.SetBackgroundColour("lightgray")
        self.Centre()


    def OnPaint(self, event):
        """
        ...
        """
        
        dc = wx.PaintDC(self)
        dc.SetPen(wx.Pen('#d4d4d4'))

        dc.SetBrush(wx.Brush('#c56c00'))
        dc.DrawRectangle(35, 15, 90, 60)

        dc.SetBrush(wx.Brush('#1ac500'))
        dc.DrawRectangle(147, 15, 90, 60)

        dc.SetBrush(wx.Brush('#539e47'))
        dc.DrawRectangle(259, 15, 90, 60)

        dc.SetBrush(wx.Brush('#004fc5'))
        dc.DrawRectangle(35, 105, 90, 60)

        dc.SetBrush(wx.Brush('#c50024'))
        dc.DrawRectangle(147, 105, 90, 60)

        dc.SetBrush(wx.Brush('#9e4757'))
        dc.DrawRectangle(259, 105, 90, 60)

        dc.SetBrush(wx.Brush('#5f3b00'))
        dc.DrawRectangle(35, 195, 90, 60)

        dc.SetBrush(wx.Brush('#4c4c4c'))
        dc.DrawRectangle(147, 195, 90, 60)

        dc.SetBrush(wx.Brush('#785f36'))
        dc.DrawRectangle(259, 195, 90, 60)

#---------------------------------------------------------------------------

def main():
    app = wx.App()
    ex = Example(None)
    ex.Show()
    app.MainLoop()

#---------------------------------------------------------------------------

if __name__ == '__main__':
    main()
