#!/usr/bin/env python
#Boa:App:BoaApp

import wx

import sys

# people say one should leave this alone and use decode/encode, or define this
# in sitecustomize.py
# either of them don't really work for me, so as long as the following does 
# this is what I will do
if hasattr(sys, "frozen"):  #Py2Exe does not run Site.py
    sys.setdefaultencoding('iso-8859-1')
    del sys.setdefaultencoding    
else:                       #The Python interpreter needs to reload the function
    reload(sys)
    sys.setdefaultencoding('iso-8859-1')
    del sys.setdefaultencoding

import os

import time as myTime
import traceback

import locale

import gettext
gettext.install('myapp', os.path.join(os.getcwd(), 'locale'), unicode=0)
localeDir = os.path.join(os.getcwd(), 'locale')
langDe = gettext.translation('myapp', localeDir, languages=['de'])
langEn = gettext.translation('myapp', localeDir, languages=['en'])

locale.setlocale(locale.LC_ALL, '')

import dialogerror

provider = wx.SimpleHelpProvider()
wx.HelpProvider_Set(provider)

import __version__

# some application folder and file settings used by dialogerror
cfgFileName = 'errDiag.cfg'
logFolderName = 'ErrorDiagTest'
stdOutFileName = 'stdoutlog.txt'
stdErrFileName = 'stderrlog.txt'
sqlLogFileName = 'sqllog.txt'

import errorDiagTestF

modules ={u'dialogerror': [0, '', u'dialogerror.py'],
 u'errorDiagTestF': [1, 'Main frame of Application', u'errorDiagTestF.py']}

class BoaApp(wx.App):
    def OnInit(self):
        self.SetupStdFolders()
        self.RedirectLogFiles()
        sys.excepthook = self.MyExceptionHandler
        
        self.DoConfig()
        self.ChangeLang(self.appConfig.Read(key='Language'))
        
        self.main = errorDiagTestF.create(None)
        self.main.Show()
        self.SetTopWindow(self.main)
        
        self.ReportException()
        
        return True

    def DoConfig(self):
        configFile = os.path.join(self.progLoc, cfgFileName)
        
        self.appConfig = wx.FileConfig(appName='MyErrorTestApp', vendorName='whoEver', localFilename=configFile)

        if not self.appConfig.HasEntry('ProgramLocation'):
            self.appConfig.Write(key='ProgramLocation', value=progLoc)
        if not self.appConfig.HasEntry('DataLocation'):
            self.appConfig.Write(key='DataLocation', value=dataLoc)
        if not self.appConfig.HasEntry('Language'):
                self.appConfig.Write(key='Language', value='en')
        if not self.appConfig.HasEntry('SQLLog'):
                self.appConfig.Write(key='SQLLog', value='False')
        if not self.appConfig.HasEntry('EMail'):
                self.appConfig.Write(key='EMail', value='')
        if not self.appConfig.HasEntry('SMTPServer'):
                self.appConfig.Write(key='SMTPServer', value='')

    def SetLang(self, lang):
        if lang in ['de']:
            langDe.install()
        else:
            langEn.install()

    def ChangeLang(self, lang):
        """Change the configured language, currently requires app restart
        """
        if lang in ['en', 'de']:
            self.appConfig.Write(key='Language', value=lang)
            self.SetLang(lang)

    def SetupStdFolders(self):
        sp = wx.StandardPaths.Get()
        self.userdir, self.userdoc = os.path.split(sp.GetDocumentsDir())
        
        self.appLoc, self.curDir = os.path.split(os.getcwd())
        self.progLoc = os.getcwd()
        self.dataLoc = os.path.join(self.appLoc, '')
        
        self.logFolder = os.path.join(self.userdir, logFolderName)
        if not os.path.exists(self.logFolder):
            os.mkdir(self.logFolder)
        
    def RedirectLogFiles(self):
        self.sqllog = file(os.path.join(self.logFolder, sqlLogFileName), 'a+')
        self.stdoutlog = file(os.path.join(self.logFolder, stdOutFileName), 'a+')
        self.stderrlog = file(os.path.join(self.logFolder, stdErrFileName), 'a+')

        sys.stdout = self.stdoutlog
        sys.stderr = self.stderrlog

    def MyExceptionHandler(self, type, value, trace_back):
        """Catch exceptions, log them to file and show error dialog
        """        
        timestamp = myTime.asctime(myTime.localtime(myTime.time()))
        self.stderrlog.write('**** %s ****\n' % timestamp)
        traceback.print_exception(type, value, trace_back, file=self.stderrlog)
        self.stderrlog.write('\n')
        # to ensure that errorDialog is shown immediately 
        self.stderrlog.flush()
        
        self.ReportException(msg=2)      

    def ReportException(self, msg = 1):
        self.SetErrDiagMsg()
        if msg == 1:
            self.msg = self.msg1
        else:
            self.msg = self.msg2

        self.msg += '\n'
        self.msg += ('Language = %s' % self.appConfig.Read(key='Language'))
        
        self.eMail = self.appConfig.Read(key='EMail')
        self.smtpServer = self.appConfig.Read(key='SMTPServer')
        myErr = False
        self.stdoutlog.seek(0)
        self.stderrlog.seek(0)
        self.sqllog.seek(0)

        if len(self.stdoutlog.read()) >0:
            myErr = True
        if len(self.stderrlog.read()) >0:
            myErr = True
        if len(self.sqllog.read()) >0:
            myErr = True

        if myErr:
            self.stdoutlog.seek(0)
            self.stderrlog.seek(0)
            self.sqllog.seek(0)

            dlg = dialogerror.DialogError(self)
            dlg.CenterOnScreen()
            try:
                dlg.ShowModal()
            finally:
                dlg.Destroy()

        self.stdoutlog.seek(0, 2)
        self.stderrlog.seek(0, 2)
        self.sqllog.seek(0, 2)

    def SetErrDiagMsg(self):
        # need this to get translations to work
        self.msg1 = _('''During the last session with "myApp" at least one programming problem occurred.

If you can provide some details on how to recreate the problem that would be very helpful in correcting it.


Yours sincerely,
whoEver
''')

        self.msg2 = _('''During this session with "myApp" at least one programming problem occurred.

If you can provide some details on how to recreate the problem that would be very helpful in correcting it.


Yours sincerely,
whoEver
''')


def main():
    application = BoaApp(redirect=True)
    application.MainLoop()

if __name__ == '__main__':
    main()
