# Replace this comment with your favorite *nix incantation.

"""
Modified from:
    CreatingCustomControls @ http://wiki.wxpython.org/CreatingCustomControls
    Andrea Gavana 2009-11-30 03:49:16

By:
    Ray Pasco
    pascor(at)verizon(dot)net
    2011-09-01  All buttons affect the lone CustomCheckbox to be able to see 
                the combined effects. Requires the improved CustomCheckBoxMod.
"""

import wx

import CustomCheckBoxMod    as CCBM

#---------------------------------------------------------------------------

FONTDEBUG = 1       # List the characteristics of substituted fonts.

class CustomCheckBoxDemoFrame( wx.Frame ) :

    def __init__( self, parent, id=wx.ID_ANY, title='', pos=(15, 15),
                  size=wx.DefaultSize, style=wx.DEFAULT_FRAME_STYLE ) :
        
        frameStyle_noMaximize = wx.DEFAULT_FRAME_STYLE ^ wx.MAXIMIZE_BOX
        wx.Frame.__init__( self, parent, id, title, pos, size, style=frameStyle_noMaximize, 
                           name='CustomCheckBoxDemoFrame' )     # All name= are for TWIT.
        self.SetClientSize( (800, 500) )
        self.SetIcon( GetIcon_Mondrian_PNG() )

        self.mainPanel = wx.Panel( self, -1, name='self.mainPanel' )
        self.mainPanel.Bind( wx.EVT_RIGHT_UP, self.OnAppExit )
        
        #-----
        
        # Create a viewable logging control for listing the event text messages.
        self.logWindow = wx.TextCtrl( self.mainPanel, -1, size=(-1, 100),
                                      style=wx.TE_MULTILINE|wx.TE_READONLY|wx.HSCROLL, 
                                      name = 'self.logWindow' )
        # Use a font guaranteed to be monospaced. 
        # wx.FONTFAMILY_MODERN isn't guaranteed to be monospaced on all platforms.
        monoFont = wx.Font( 9, wx.FONTFAMILY_TELETYPE, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_NORMAL )
        self.logWindow.SetFont( monoFont )
        
        self.logWindow.Bind( wx.EVT_RIGHT_UP, self.OnAppExit )
        
        # Set the wxWidgets log target to be this textctrl
        wx.Log_SetActiveTarget( MyLog( self.logWindow ) )
        
        #-----
        
        useFont = wx.Font( 10, wx.SWISS, wx.NORMAL, wx.NORMAL, False )
        
        # Create the single left-side disable-able and button-checkable checkbox.
        ccbLabel = 'CCBM.CustomCheckBoxMod'
        self.custChkBox = CCBM.CustomCheckBoxMod( self.mainPanel, -1, 
                                                  ccbLabel, font=useFont, 
                                                  name='self.custChkBox' )
        self.custChkBox.Bind( wx.EVT_CHECKBOX, self.OnCheckBox )
        
        #-----
        
        # Create a button that enables/disables the first CustomCheckBox
        self.leftChkBoxEnabler_Btn = wx.Button( self.mainPanel, -1, 'Disable', 
                                                name='self.leftChkBoxEnabler_Btn' )
        self.leftChkBoxEnabler_Btn.Bind( wx.EVT_BUTTON, self.OnEnable )
        
        # Create another button that toggles the state of the CustomCheckBox
        self.leftChkBoxToggler_Btn = wx.Button( self.mainPanel, -1, 'Set Checked', 
                                                name='self.leftChkBoxToggler_Btn' )
        self.leftChkBoxToggler_Btn.Bind( wx.EVT_BUTTON, self.OnToggle )
        #-----
        
        btnLabel = 'Set CcBox Font'
        self.chooseCcBoxFont_btn = wx.Button( self.mainPanel, -1, btnLabel, 
                                              name='self.chooseCcBoxFont_btn' )
        self.chooseCcBoxFont_btn.Bind( wx.EVT_BUTTON, self.OnChooseFont )
        
        btnLabel = 'Set CcBox BG Color'
        self.chooseCcBoxBgColor_btn = wx.Button( self.mainPanel, -1, btnLabel, 
                                                 name='self.chooseCcBoxBgColor_btn' )
        self.chooseCcBoxBgColor_btn.Bind( wx.EVT_BUTTON, self.OnBgColorButton )
        
        btnLabel = 'Set CcBox FG Color'
        self.chooseCcBoxFgColor_btn = wx.Button( self.mainPanel, -1, btnLabel, 
                                                 name='self.chooseCcBoxFgColor_btn' )
        self.chooseCcBoxFgColor_btn.Bind( wx.EVT_BUTTON, self.OnFgColorButton )
        #-----
        
        # Layout all the checkboxes and buttons.
        self.LayoutAllMainPanelItems()
        
    #end __init__
    
    #----------------------------------
    
    def LayoutAllMainPanelItems( self ) :
        """ This code is called only in __init__, but is too long to be put there. 
        """
        
        leftColBtns_vSzr = wx.BoxSizer( wx.VERTICAL )
        
        leftColBtns_vSzr.Add( self.leftChkBoxEnabler_Btn, 0 )
        AddLinearSpacer( 10, leftColBtns_vSzr )
        leftColBtns_vSzr.Add( self.leftChkBoxToggler_Btn, 0 )
        
        #-----
        
        rightColBtns_vSzr = wx.BoxSizer( wx.VERTICAL )
        
        rightColBtns_vSzr.Add( self.chooseCcBoxFont_btn,    0 )
        AddLinearSpacer( 10, rightColBtns_vSzr )
        rightColBtns_vSzr.Add( self.chooseCcBoxFgColor_btn, 0 )
        AddLinearSpacer( 10, rightColBtns_vSzr )
        rightColBtns_vSzr.Add( self.chooseCcBoxBgColor_btn, 0 )
        
        #-----
        
        allCtrls_hSzr = wx.BoxSizer( wx.HORIZONTAL )
        
        AddLinearSpacer( 50, allCtrls_hSzr )
        allCtrls_hSzr.Add( self.custChkBox, 0, wx.CENTER )
        AddLinearSpacer( 25, allCtrls_hSzr )
        allCtrls_hSzr.Add( leftColBtns_vSzr,   0, wx.CENTER )
        AddLinearSpacer( 50, allCtrls_hSzr )
        allCtrls_hSzr.Add( rightColBtns_vSzr,  0, wx.CENTER )
        AddLinearSpacer( 50, allCtrls_hSzr )
        
        #-----
        
        mainPnl_vSzr = wx.BoxSizer( wx.VERTICAL )
        
        AddLinearSpacer( 20, mainPnl_vSzr )
        mainPnl_vSzr.Add( allCtrls_hSzr,  0, 0 )
        AddLinearSpacer( 20, mainPnl_vSzr )
        mainPnl_vSzr.Add( self.logWindow, 1, wx.EXPAND )   # 1 :== expand along primary sizer axis
        
        #-----
        
        # Associate mainPnl_vSzr to the panel which contains all this sizer's items.
        self.mainPanel.SetSizer( mainPnl_vSzr )
        
        # Add the panel to the frame sizer        
        main_vSzr = wx.BoxSizer( wx.VERTICAL )
        main_vSzr.Add( self.mainPanel, 1, wx.EXPAND )
        
        # Calling self.SetSizerAndFit() has the benefit of setting the
        #   Frame's minimum size. However, It also will shrink it, too.
        # Query the actual size so that it can be restored after SetSizerAndFit().
        selfClientSize = self.GetClientSize()
        
        # Associate main_vSzr to the Frame which contains all self.mainPanel's items.
        self.SetSizerAndFit( main_vSzr )   # Sets self's minSize.
        
        self.SetClientSize( selfClientSize )
        
    #end LayoutAllMainPanelItems def
    
    #----------------------------------
    
    def OnCheckBox( self, event ) :
        
        # Grab the CustomCheckBox that generated the event
        control = event.GetEventObject()
        
        # Get its label
        label = control.GetLabel()
        
        # Get the checked/unchecked value
        value = event.IsChecked()
        
        # Display the label and some info in the wx.LogTextCtrl
        self.logWindow.AppendText( 'CustomCheckBox event from ==> ' + label + \
                                   ', checked = ' + repr( value ) + '\n' )
    #end def
    
    #----------------------------------
    
    def OnEnable( self, event ) :
        
        if self.custChkBox.IsEnabled() :
            # we are enabled, so let's disable ourselves and also change the
            #   button label to 'Enable'
            self.custChkBox.Enable( False )
            self.leftChkBoxEnabler_Btn.SetLabel( 'Enable' )
        else :
            # we are disabled, so let's enable ourselves and also change the
            #   button label to 'Disable'
            self.custChkBox.Enable( True )
            self.leftChkBoxEnabler_Btn.SetLabel( 'Disable' )
        #end if
        
    #end def
    
    #----------------------------------
    
    def OnToggle( self, event ) :

        if self.custChkBox.IsChecked() :
            # we are checked, so let's go for unchecking...
            self.custChkBox.SetValue( 0 )
            self.leftChkBoxToggler_Btn.SetLabel( 'Set Checked' )
            
        else :
            # we are unchecked, so let's go for checking...
            self.custChkBox.SetValue( 1 )
            self.leftChkBoxToggler_Btn.SetLabel( 'Set Very Unchecked' )
            
        # The button size changes, so stimulate its sizer.
        self.Redraw()    # HACK !  HACK !  HACK !
            
    #end def
    
    #----------------------------------
    
    def Redraw( self ) :
        """ 
        Resizing and redrawing of self. This algorithm is a "hack" !
        This hack fails if the top level Frame/Dialog is maximized. 
        """
        
        # Force re-layout of self. HACK !  HACK !  HACK !
        # There really must be a better way, not just a different way, 
        #   to accomplish auto-resizing and auto-repainting. I wonder what that is...
        topParent = self.GetTopLevelParent()
        topWid, topHgt = topParent.GetClientSize()
        
        topParent.SetClientSize( (topWid-1, topHgt) )   # "Bump" the top level Frame size
        topParent.SetClientSize( (topWid,   topHgt) )   # Reset the size.
        
        self.Refresh()      # Repaint self.
        
    #end def
    
    #----------------------------------
    
    def OnChooseFont( self, event ) :
        
        initialFont = self.custChkBox.GetFont()
        if not initialFont :
            font = wx.SystemSettings_GetFont( wx.SYS_DEFAULT_GUI_FONT )
            
        data = wx.FontData()
        data.SetInitialFont( initialFont )
        dlg = wx.FontDialog( self, data )
        
        if dlg.ShowModal() == wx.ID_OK :
            
            dlgDataObject = dlg.GetFontData()
            chosenFont = dlgDataObject.GetChosenFont()
            self.custChkBox.SetFont( chosenFont )
            
            if FONTDEBUG :
                self.ListFontAttributes( chosenFont )
            
        #end if
            
        # Destroy the dialog only after getting its information !
        dlg.Destroy()
    
    #end def
    
    #----------------------------------
    
    def ListFontAttributes( self, font ) :
        
        #font = wx.Font( pointSize, family, style, weight, underline, face, encoding ) 
        # Note that each wx.Font.Get() call has a corresponding .Set() call.
        self.logWindow.AppendText( '\n' )
        self.logWindow.AppendText( '----  ListFontAttributes()' + '\n' )
        self.logWindow.AppendText( '\t font.GetFaceName()      ' + font.GetFaceName() +     '\n' )
        self.logWindow.AppendText( '\t font.GetPointSize()     ' + repr( font.GetPointSize() ) + '\n' )
        self.logWindow.AppendText( '\t font.GetFamilyString()  ' + font.GetFamilyString() + '\n' )
        self.logWindow.AppendText( '\t font.GetStyleString()   ' + font.GetStyleString() +  '\n' )
        self.logWindow.AppendText( '\t font.GetWeightString()  ' + font.GetWeightString() + '\n' )
        self.logWindow.AppendText( '\t font.GetUnderlined()    ' + repr( font.GetUnderlined() ) + '\n' )
        self.logWindow.AppendText( '\n' )
        
    #end def
    
    #----------------------------------
    
    def OnBgColorButton( self, evt ):
        
        colorChoice = self.ColorChooseDialog()
        if colorChoice :
            self.custChkBox.SetBackgroundColour( colorChoice )
        
    #end def
    
    #----------------------------------
    
    def OnFgColorButton( self, evt ):
        
        colorChoice = self.ColorChooseDialog()
        if colorChoice :
            self.custChkBox.SetForegroundColor( colorChoice )
        
    #----------------------------------
    
    def ColorChooseDialog( self ) :
        
        colorChoice = None              # default value for dialog quit
        dlg = wx.ColourDialog( self )

        # Ensure the full colour dialog is displayed, not the abbreviated version.
        dlg.GetColourData().SetChooseFull( True )

        if dlg.ShowModal() == wx.ID_OK:

            colorObject = dlg.GetColourData()

            # The actual colour data will be returned as a three-tuple, (r, g, b).
            colorChoice = colorObject.GetColour().Get()
            
        #end if
        
        dlg.Destroy()
        
        return colorChoice
        
    #end def
    
    #----------------------------------
    
    def OnAppExit( self, event ) :
        
        self.Close()    # # Exit app.MainLoop()
        
#end CustomCheckBoxDemoFrame class

#---------------------------------------------------------------------

# This file was generated by C:\PROGRA~2\Python26\Lib\Image2PyFile.py

from wx.lib.embeddedimage import PyEmbeddedImage

catalog = {}
#---------------------------------------------------------------------

Mondrian_PNG = PyEmbeddedImage( 
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAIAAAD8GO2jAAAAA3NCSVQICAjb4U/gAAAAZ0lE"
    "QVRIie2VSQ6AMAwDPYiP8XKeFq4USsUWAcI+upHn0LiVkoWkqLkRa/t4OnTXU9oy4AeAdKHa"
    "ygPnegCUvXIPXgDoEzLJBczXz6+pAQZIahQN2Dq6B7DnOwBpLK1hOfP9OzDgeU1onhFFk1wz"
    "3AAAAABJRU5ErkJggg=="
    )

catalog["Mondrian.PNG"] = "Mondrian_PNG"
GetData_Mondrian_PNG   = Mondrian_PNG.GetData
GetImage_Mondrian_PNG  = Mondrian_PNG.GetImage
GetBitmap_Mondrian_PNG = Mondrian_PNG.GetBitmap
GetIcon_Mondrian_PNG   = Mondrian_PNG.GetIcon

#---------------------------------------------------------------------------

class MyLog( wx.PyLog ) :
    """ A custom wxLog class. """

    def __init__( self, textCtrl ) :
        
        wx.PyLog.__init__( self )
        
        self.tc = textCtrl 
        
    #end __init__
    
    #----------------------------------
        
    def LogString( self, message, timeStamp ) :
        
        if self.tc :
            self.tc.AppendText( message + '\n' )
        
    #end def
    
#emd MyLog class

#------------------------------------------------------------------------------

def AddLinearSpacer( linearSpacingAlongOnlyTheMajorAxis, boxsizer ) :
    """ 
    A one-dimensional spacer for use with all BoxSizers. 
    This eliminates any possibility of a fixed-size rectangular spacer
      from interfering with adjacent controls on the sizer's minor axis.
    """
    
    orientation = boxsizer.GetOrientation()
    if   (orientation == wx.HORIZONTAL) :
        boxsizer.Add( (linearSpacingAlongOnlyTheMajorAxis, 0) )
    
    elif (orientation == wx.VERTICAL) :
        boxsizer.Add( (0, linearSpacingAlongOnlyTheMajorAxis) )
    
#end def

#==============================================================================

if __name__ == '__main__' :
    
    app = wx.App( redirect=False )
    frame = CustomCheckBoxDemoFrame( None, -1, 'CustomCheckBoxMod wxPython Demo ;-)',
                               size=(600, 400) )
    frame.Show()
    
    if 0 :
        from wx.lib.inspection import InspectionTool
        inspTool = InspectionTool()
        inspTool.Show( refreshTree=True )      
    
    app.MainLoop()

#end def
