import wx
from wx.build.config import *
from pprint import pprint
from os.path import join as pj

# wxdir should really be set in the environment...
print 'path to wx (from WXWIN env var):', WXDIR

# add some include dirs for SWIG
#swig_args += ['-I' + pj(*([WXPY_SRC] + paths)) for paths in (
#  ['src'],
#  ['..', 'include'],
#  ['..', 'include', 'wx', 'msw'],
#  ['include', 'wx', 'wxPython', 'i_files'],
#)]

includes += [
    '%s\\include' % WXPY_SRC,
    '%s\\..\\include' % WXPY_SRC,
    pj(WXPY_SRC, 'lib', 'vc_dll', 'mswuh'),
]

swig_sources = run_swig(['scrollwindow.i'], '', '.', '.',
                        USE_SWIG, swig_force, swig_args, swig_deps)
                        
# common args to distuils.Extension
extopts = dict(include_dirs       = includes,
               define_macros      = defines,
               library_dirs       = libdirs,
               libraries          = libs,
               
               extra_compile_args = cflags,
               extra_link_args    = lflags,

               swig_opts = swig_args,
               language = 'c++',)


def simpleExt(name, path = './'):
    return Extension('_%s' % name, ['%s%s.cpp' % (path, name), '%s%s_wrap.cpp' % (path, name)], **extopts)

setup(ext_modules = [simpleExt('scrollwindow')])