/**
  ScrollWindow.h
  
  Like wxScrolledWindow, except uses the pixel vaulues set by
  wxWindow::SetVirtualSize as the only units to scroll by.
*/

#ifndef _SCROLLWINDOW_H_
#define _SCROLLWINDOW_H_

#include <wx/wx.h>

class ScrollWindow : public wxWindow {
public:
	ScrollWindow(wxWindow* parent, wxWindowID = -1);
	virtual ~ScrollWindow();

	void AdjustScrollbars(int x = -1, int y = -1);
	void PrepareDC(wxDC& dc);
	
	void SetVirtualSize(const wxSize& size);
	void SetVirtualSize(int width, int height);		
protected:
     void handleScrollEvent(wxScrollWinEvent& e);

private:
    DECLARE_CLASS(ScrollWindow)


};

#endif