#include "scrollwindow.h"

IMPLEMENT_CLASS(ScrollWindow, wxWindow);

ScrollWindow::ScrollWindow(wxWindow* parent, wxWindowID id)
	: wxWindow(parent, id)
{
}

ScrollWindow::~ScrollWindow() {}

void ScrollWindow::AdjustScrollbars(int x, int y)
{
    wxRect r(GetRect());
    wxRect virtualRect(GetVirtualSize());

    // x and y default to current position
    if (x == -1) x = GetScrollPos(wxHORIZONTAL);
    if (y == -1) y = GetScrollPos(wxVERTICAL);

    SetScrollbar(wxHORIZONTAL, x, r.width,  virtualRect.width);
    SetScrollbar(wxVERTICAL,   y, r.height, virtualRect.height);
}

void ScrollWindow::handleScrollEvent(wxScrollWinEvent& e)
{
    e.Skip();        
    wxPoint lineSize(10, 10); // TODO: make accessor

    wxRect clientRect(GetClientRect());
    wxRect virtualRect(GetVirtualSize());    
    wxEventType scrollType(e.GetEventType());    
    int orientation = e.GetOrientation();
    bool h = orientation == wxHORIZONTAL;

    int x = GetScrollPos(wxHORIZONTAL),
         y = GetScrollPos(wxVERTICAL);
    
    wxPoint newPos(x, y);    
    wxPoint pageSize(clientRect.width, clientRect.height);

    // THUMBTRACK: dragging the scroll thumb
    if ( scrollType == wxEVT_SCROLLWIN_THUMBTRACK ) {
        if (h) newPos.x = e.GetPosition();
        else   newPos.y = e.GetPosition();
        
    // THUMBRELEASE: mouse up on the thumb
    } else if ( scrollType == wxEVT_SCROLLWIN_THUMBRELEASE ) {
        if (h) newPos.x = e.GetPosition();
        else   newPos.y = e.GetPosition();

    // LINEDOWN: clicking the down arrow
    } else if ( scrollType == wxEVT_SCROLLWIN_LINEDOWN ) {
        if (h) newPos.x += lineSize.x;
        else   newPos.y += lineSize.y;
    
    // LINEUP: clicking the up arrow
    } else if ( scrollType == wxEVT_SCROLLWIN_LINEUP ) {
        if (h) newPos.x -= lineSize.x;
        else   newPos.y -= lineSize.y;
    
    // PAGEDOWN: clicking below the scroll thumb
    } else if ( scrollType == wxEVT_SCROLLWIN_PAGEDOWN ) {
        // self.RefreshRect() // why is this necessary?
        if (h) newPos.x += pageSize.x;
        else   newPos.y += pageSize.y;

    // PAGEUP: clicking above the scroll thumb
    } else if ( scrollType == wxEVT_SCROLLWIN_PAGEUP ) {
        // self.Refresh()
        if (h) newPos.x -= pageSize.x;
        else   newPos.y -= pageSize.y;
    }

    // keep scroll position within bounds
    int maxx = virtualRect.width - clientRect.width,
        maxy = virtualRect.height - clientRect.height;
    
    if (newPos.x < 0) newPos.x = 0;
    else if (newPos.x > maxx) newPos.x = maxx;
        
    if (newPos.y < 0) newPos.y = 0;
    else if (newPos.y > maxy) newPos.y = maxy;
    
    // do physical scrolling
    wxWindow::ScrollWindow(-(newPos.x - x), -(newPos.y - y));

    // readjust scrollbars
    AdjustScrollbars(newPos.x, newPos.y);
}


void ScrollWindow::PrepareDC(wxDC& dc) {
    wxPoint pt(dc.GetDeviceOrigin());
    int x = GetScrollPos(wxHORIZONTAL),
        y = GetScrollPos(wxVERTICAL);
    
    dc.SetDeviceOrigin(pt.x - x, pt.y - y);
}

// override SetVirtualSize so we can AdjustScrollbars
void ScrollWindow::SetVirtualSize(int width, int height) {
    wxWindow::SetVirtualSize(width, height);
    AdjustScrollbars();
    Refresh();
}

void ScrollWindow::SetVirtualSize(const wxSize& size) {
    SetVirtualSize(size.x, size.y);   
}
