#/usr/bin/env python

""" wxEXPAND_DEMO_B_2.PY """

import wx
import AddLinearSpacer as als

#--------------------------------------------------------------------

class AppFrame( wx.Frame ) :
    """ Demonstrate spacing beteween controls and the 4 container sides 
    as well as both major and minor axis centering.
    
    This demo also prints comparisons between the panels' proportional
    widths set by the sizer verses proportion calculations done in this app.
    """
    
    def __init__( self ) :
        
        #-----  Configure the Frame.
        
        wx.Frame.__init__( self, parent=None, id=wx.NewId(), 
                                 title='wxEXPAND_DEMO_B_2.PY' )
        self.ClientSize = (400, 350)
                                 
        # A panel is needed for tab-traversal and frame background color capabilities.
        # The first control instantiated in a Frame automatically expands 
        #   to the Frame's client size.  This is unique to Frames.
        self.frm_pnl = wx.Panel( self )
        self.frm_pnl.BackgroundColour = (255, 255, 230)  # Contrast with panels below.
        
        #-----  Create the controls
        
        self.left_pnl = wx.Panel( self.frm_pnl )    # Size will be set by the sizer.
        self.left_pnl.BackgroundColour  = (200, 250, 200)      # green
        
        # Set a fixed horizontal panel size.  The sizer will control the vertical size.
        # The Y ordinate is ignored, but a value must be given.
        self.left_pnl.SetSize( (0, 200) )  
        
        self.right_pnl = wx.Panel( self.frm_pnl )
        self.right_pnl.BackgroundColour = (200, 230, 250)      # blue
        self.right_pnl.SetSize( (200, 0) )  
        
        #-----  Create the sizer and add the controls to it.
        
        # This sizer will set right_pnl's width 
        #   to be proportional to self.left_pnl's.
        self.frmPnl_horzSizer = wx.BoxSizer( wx.HORIZONTAL )
        
        topAndBottomSpacing = 30
        border_flags = wx.TOP | wx.BOTTOM       # for controls' border padding
        expand_flag = wx.EXPAND                 # resize controls when Frame resizes
        alignment_flags = wx.ALIGN_CENTER       # vertical minor axis centering
        allFlags = border_flags | expand_flag | alignment_flags
        
        topAndBottomSpacing = 30
        self.leftAndRightSpacing = 50
        self.middleSpacing = 40
        
        als.AddLinearSpacer( self.frmPnl_horzSizer, self.leftAndRightSpacing )
        
        self.winLeft_horzProp  = 17    # horz width proportion
        self.winRight_horzProp = 23    # horz width proportion
        
        self.frmPnl_horzSizer.Add( self.left_pnl, proportion=self.winLeft_horzProp, 
                              flag=allFlags, border=topAndBottomSpacing )
        
        als.AddLinearSpacer( self.frmPnl_horzSizer, self.middleSpacing )
        
        self.frmPnl_horzSizer.Add( self.right_pnl, proportion=self.winRight_horzProp, 
                              flag=allFlags, border=topAndBottomSpacing )
        
        als.AddLinearSpacer( self.frmPnl_horzSizer, self.leftAndRightSpacing )
        
        #----- Invoke the sizer via its container.
        
        self.frm_pnl.SetSizer( self.frmPnl_horzSizer )
        self.frm_pnl.Layout()
        
        #-----
        
        # Print of some info concerning sizer proportion settings.
        self.Bind( wx.EVT_SIZE, self.OnSize )
        
    #end def __init__
    
    #-----------------------------
    
    def OnSize( self, event ) :
        """ Compare the actual control widths to the calculated expected ones
        #   only when the Frame's width has changed.
        """
        self.CompareProportions()
        
        # This handler intercepts all resizing events. 
        # Allow any other existing internal wxPython resize handlers to run, too.
        event.Skip()
        
    #end def
    
    #-----------------------------
    
    def CompareProportions( self ) :
        """  Compare the actual control widths to the calculated expected ones
        only when the Frame's width has changed.
        """
        
        currClientWidth = self.ClientSize[ 0 ]
        
        # Use a technique to instantiate a class variable outside of __init__().
        # This helps to keep __ini__ unnecessarily cluttered.
        try :                           # Is this variable instantiated yet ?
            self.prevClientWidth        # Yes, if an exception doesn't occur.
            
        except :                        # No
            self.prevClientWidth = 0    # Instantiate it: It needs to be referenced later.
            return
        #end try
        
        if currClientWidth == self.prevClientWidth :    # Frame width has not changed.
            return
            
        #-----
        
        # Query the widths set by the sizer.
        leftPnl_width,  leftPnlHeight = self.left_pnl.Size
        rightPnl_width, leftPnlHeight = self.right_pnl.Size
        
        # Calculate what the panel widths should be from the current client width.
        
        alreadyAllocatedSpace = 2*self.leftAndRightSpacing + self.middleSpacing
        allocatableSpace = currClientWidth - alreadyAllocatedSpace
        
        calcLeft_width  = allocatableSpace * (float(self.winLeft_horzProp)  \
                                               / (self.winLeft_horzProp + self.winRight_horzProp))
        calcLeft_width = int( round( calcLeft_width ) )
        
        calcRight_width = allocatableSpace * (float(self.winRight_horzProp) \
                                               / (self.winLeft_horzProp + self.winRight_horzProp))
        calcRight_width = int( round( calcRight_width ) )
        
        # Print the results.
        print
        print '----  Frame Client Width : ', currClientWidth
        print '----  Actual     Left and Right Control Widths : ', leftPnl_width,  rightPnl_width
        print '----  Calculated Left and Right Control Widths : ', calcLeft_width, calcRight_width
        
        #-----
        
        self.prevClientWidth = currClientWidth
        
    #end def
    
#end class AppFrame

#--------------------------------------------------------------------

myApp = wx.PySimpleApp( redirect=False )   # Send errors to command window, not a pop-up.
appFrame = AppFrame()
appFrame.Show()
appFrame.CompareProportions()   # Print the frame's initial width statistics.
myApp.MainLoop()
