#/usr/bin/env python

# wxEXPAND_DEMO_A_3.PY

import wx

#------------------------------------------------------------------------------

class AppFrame( wx.Frame ) :
    
    def __init__( self ) :
        
        wx.Frame.__init__( self, parent=None, id=-1, title='wx.EXPAND Demo A3' )
        
        self.Position = (200, 0)
        self.ClientSize = (300, 200)        # Set client area. Frame size is unimportant.
        
        # A panel is needed for tab-traversal and platform background color capabilities.
        # The first control instantiated in a Frame automatically expands 
        #   to the Frame's client size.  This is unique to Frames.
        frm_pnl = wx.Panel( self )
        frm_pnl.BackgroundColour = (255, 255, 230)  # Contrast with panels below.
        
        #-----

        left_panel  = wx.Panel( frm_pnl )
        left_panel.BackgroundColour  = (200, 250, 200)      # green
        
        right_panel = wx.Panel( frm_pnl )
        right_panel.BackgroundColour = (200, 230, 250)      # blue
        
        frmPnl_horzSizer = wx.BoxSizer( wx.HORIZONTAL )
        frmPnl_horzSizer.Add( left_panel,  proportion=1, flag=wx.EXPAND )
        frmPnl_horzSizer.Add( right_panel, proportion=1, flag=wx.EXPAND )
        
        #-----  Invoke the sizer via its container.
        
        frm_pnl.SetSizer( frmPnl_horzSizer )
        frm_pnl.Layout()
        
    #end __init__ def
    
    #--------------

    def ExitApp( self, event ) :
        self.Close()
        
#end AppFrame class

#==============================================================================

MyApp = wx.App( redirect=False )
AppFrame().Show()
MyApp.MainLoop()
