
""" Simple, foolproof function to properly insert a
one-dimensional spacer along its major axis 
regardless of the sizer's orientation.

This is a safer alternative to the .AddSpacer( n ) 
method which produces a square shaped spacer which can
unintentionally interfere with adjacent controls and 
control blocks stacked along the minor axis by an 
outer sizer. 

Ray Pasco
2010-09-25-Sat__PM-03-14-19__September
"""

import wx

def AddLinearSpacer( boxsizer, pixelSpacing ) :
    """ A one-dimensional spacer for use with any BoxSizer """

    orientation = boxsizer.GetOrientation()
    if   (orientation == wx.HORIZONTAL) :
        boxsizer.Add( (pixelSpacing, 0) )

    elif (orientation == wx.VERTICAL) :
        boxsizer.Add( (0, pixelSpacing) )
    #end if

#end def
