#/usr/bin/env python

""" wxEXPAND_DEMO_B_1.PY """

import wx
import AddLinearSpacer as als

#--------------------------------------------------------------------

class AppFrame( wx.Frame ) :
    """ Demonstrate spacing beteween controls and the container edges 
    as well as both major and minor axis centering"""
    
    def __init__( self ) :
        
        #-----  Configure the Frame.
        
        wx.Frame.__init__( self, parent=None, id=wx.NewId(), 
                                 title='wxEXPAND_DEMO_B_1.PY' )
        self.ClientSize = (400, 350)
                                 
        # A panel is needed for tab-traversal and platform background color capabilities.
        # The first control instantiated in a Frame automatically expands 
        #   to the Frame's client size.  This is unique to Frames.
        frm_pnl = wx.Panel( self )
        frm_pnl.BackgroundColour = (255, 255, 230)  # Contrast with panels below.
        
        #-----  Create the controls
        
        left_pnl = wx.Panel( frm_pnl )    # Size will be set by the sizer.
        left_pnl.BackgroundColour  = (200, 250, 200)      # green
        
        # Set a fixed horizontal panel size.  The sizer will control the vertical size.
        # The Y ordinate is ignored, but a value must be given.
        left_pnl.SetSize( (0, 200) )  
        
        right_pnl = wx.Panel( frm_pnl )
        right_pnl.BackgroundColour = (200, 230, 250)      # blue
        right_pnl.SetSize( (200, 0) )  
        
        #-----  Create the sizer and add the controls to it.
        
        # This sizer will set right_pnl's width 
        #   to be proportional to left_pnl's.
        self.frmPnl_horzSizer = wx.BoxSizer( wx.HORIZONTAL )
        
        border_flags = wx.TOP | wx.BOTTOM       # for controls' border padding
        expand_flag = wx.EXPAND                 # resize controls when Frame resizes
        alignment_flags = wx.ALIGN_CENTER       # vertical minor axis centering
        allFlags_ORed = border_flags | expand_flag | alignment_flags
        
        topAndBottomSpacing = 30
        self.leftAndRightSpacing = 50
        self.middleSpacing = 40
        
        als.AddLinearSpacer( self.frmPnl_horzSizer, self.leftAndRightSpacing )
        
        self.winLeft_horzProp  = 17    # horz width proportion
        self.winRight_horzProp = 23    # horz width proportion
        
        self.frmPnl_horzSizer.Add( left_pnl, proportion=self.winLeft_horzProp, 
                              flag=allFlags_ORed, border=topAndBottomSpacing )
        
        als.AddLinearSpacer( self.frmPnl_horzSizer, self.middleSpacing )
        
        self.frmPnl_horzSizer.Add( right_pnl, proportion=self.winRight_horzProp, 
                              flag=allFlags_ORed, border=topAndBottomSpacing )
        
        als.AddLinearSpacer( self.frmPnl_horzSizer, self.leftAndRightSpacing )
        
        #----- Invoke the sizer via its container.
        
        frm_pnl.SetSizer( self.frmPnl_horzSizer )
        frm_pnl.Layout()
        
    #end def __init__
    
#end class AppFrame

#--------------------------------------------------------------------

myApp = wx.PySimpleApp( redirect=False )   # Send errors to command window, not a pop-up.
appFrame = AppFrame()
appFrame.Show()
myApp.MainLoop()


